/*
 * Decompiled with CFR 0.152.
 */
package fi.evolver.ai.vaadin.admin;

import fi.evolver.ai.vaadin.component.i18n.VaadinTranslations;
import fi.evolver.ai.vaadin.entity.Chat;
import fi.evolver.ai.vaadin.entity.ChatMessage;
import fi.evolver.ai.vaadin.entity.Prompt;
import fi.evolver.ai.vaadin.view.AdminBaseView;
import fi.evolver.utils.DateUtils;
import java.time.LocalDate;
import java.util.List;
import java.util.Optional;

public class ChatExportGenerator {
    private ChatExportGenerator() {
    }

    public static String generateChatExport(List<Chat> chats, LocalDate startDate, LocalDate endDate, AdminBaseView.ExportType type, VaadinTranslations t) {
        StringBuilder builder = new StringBuilder();
        builder.append("# Chats between: ").append(startDate.format(DateUtils.FORMAT_DATE_FI)).append(" - ").append(endDate.format(DateUtils.FORMAT_DATE_FI)).append("\n\n");
        if (chats.isEmpty()) {
            builder.append(t.getTranslation("view.admin.export.noChatsFound", new Object[0]));
            return builder.toString();
        }
        builder.append("%d chats in total\n\n".formatted(chats.size()));
        for (int i = 0; i < chats.size(); ++i) {
            Chat chat = chats.get(i);
            builder.append("### Chat %d: ".formatted(i + 1)).append(chat.getSummary() != null ? chat.getSummary() : "").append("\n\n");
            for (ChatMessage chatMessage : chat.getChatMessages()) {
                Prompt prompt;
                builder.append("**").append((Object)chatMessage.getRole()).append("** (").append(chatMessage.getSendTime().format(DateUtils.FORMAT_DATE_TIME_FI)).append("): ").append("\n").append(chatMessage.getMessage()).append("\n");
                if (type == AdminBaseView.ExportType.FULL && chatMessage.getRole() == ChatMessage.ChatMessageRole.USER && (prompt = chatMessage.getPrompt()) != null) {
                    builder.append("\n").append("**PROMPT**: ").append(prompt.getPrompt()).append("\n\n").append("Token count: ").append(prompt.getTokenCount()).append("\n").append("Chat rating: ").append(Optional.ofNullable(chat.getChatRating()).map(r -> r.toString()).orElse("-")).append("\n");
                }
                builder.append("\n");
            }
            builder.append("---\n");
        }
        return builder.toString();
    }
}

