/*
 * Decompiled with CFR 0.152.
 */
package fi.evolver.ai.vaadin.component;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.DetachEvent;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.button.ButtonVariant;
import com.vaadin.flow.component.dialog.Dialog;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.component.html.Paragraph;
import com.vaadin.flow.component.icon.Icon;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.messages.MessageInput;
import com.vaadin.flow.component.notification.Notification;
import com.vaadin.flow.component.notification.NotificationVariant;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.component.shared.ThemeVariant;
import com.vaadin.flow.component.upload.Receiver;
import com.vaadin.flow.component.upload.Upload;
import com.vaadin.flow.component.upload.UploadI18N;
import com.vaadin.flow.component.upload.receivers.MultiFileMemoryBuffer;
import com.vaadin.flow.dom.DomEventListener;
import com.vaadin.flow.dom.Style;
import elemental.json.JsonObject;
import fi.evolver.ai.spring.AsyncRunner;
import fi.evolver.ai.spring.Model;
import fi.evolver.ai.spring.assistant.Assistant;
import fi.evolver.ai.spring.assistant.AssistantApi;
import fi.evolver.ai.spring.assistant.AssistantPrompt;
import fi.evolver.ai.spring.assistant.AssistantResponse;
import fi.evolver.ai.spring.chat.ChatApi;
import fi.evolver.ai.spring.chat.ChatResponse;
import fi.evolver.ai.spring.chat.prompt.ChatPrompt;
import fi.evolver.ai.spring.chat.prompt.Message;
import fi.evolver.ai.spring.file.AiFile;
import fi.evolver.ai.spring.provider.openai.OpenAiAssistantResponse;
import fi.evolver.ai.vaadin.ChatAttachmentRepository;
import fi.evolver.ai.vaadin.ChatRepository;
import fi.evolver.ai.vaadin.component.ChatMessageContainer;
import fi.evolver.ai.vaadin.component.FileChatMessageContainer;
import fi.evolver.ai.vaadin.component.FileInfoDialogUtils;
import fi.evolver.ai.vaadin.component.StarRatingComponent;
import fi.evolver.ai.vaadin.component.i18n.UploadI18nFactory;
import fi.evolver.ai.vaadin.entity.Chat;
import fi.evolver.ai.vaadin.entity.ChatMessage;
import fi.evolver.ai.vaadin.util.AuthUtils;
import fi.evolver.ai.vaadin.util.ChatUtils;
import fi.evolver.ai.vaadin.view.HistoryAwareChat;
import fi.evolver.basics.spring.log.LogMetadataAttribute;
import fi.evolver.basics.spring.util.MessageChainUtils;
import fi.evolver.utils.ContextUtils;
import fi.evolver.utils.attribute.TypedAttribute;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vaadin.lineawesome.LineAwesomeIcon;

public class AiAssistantComponent
extends VerticalLayout
implements HistoryAwareChat<Component> {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(AiAssistantComponent.class);
    private static final LogMetadataAttribute CHAT_ID = new LogMetadataAttribute("ChatId");
    private final Button startNewChat = new Button(LineAwesomeIcon.EDIT.create());
    private final StarRatingComponent chatRating = new StarRatingComponent((arg_0, arg_1) -> ((AiAssistantComponent)this).getTranslation(arg_0, arg_1));
    private final Div chatRatingContainer = new Div();
    private final Dialog fileInfoDialog;
    private final ChatApi chatApi;
    private final AssistantApi assistantApi;
    private final AssistantPrompt assistantPrompt;
    private final Model<ChatApi> summaryModel;
    private final ChatRepository chatRepository;
    private final ChatAttachmentRepository chatAttachmentRepository;
    private final Class<? extends Component> viewClass;
    private final AsyncRunner asyncRunner;
    private Chat chatSession;
    private int maxLength = Integer.MAX_VALUE;
    private String chatType;
    private ChatMessageContainer chatMessageContainer;
    private Assistant assistant;
    private Map<String, String> fileIdByName = new HashMap<String, String>();
    private Upload upload;

    public AiAssistantComponent(ChatApi chatApi, AssistantApi assistantApi, AssistantPrompt assistantPrompt, Model<ChatApi> summaryModel, ChatRepository chatRepository, ChatAttachmentRepository chatAttachmentRepository, Class<? extends Component> viewClass, AsyncRunner asyncRunner) {
        this.chatApi = chatApi;
        this.assistantApi = assistantApi;
        this.assistantPrompt = assistantPrompt;
        this.summaryModel = summaryModel;
        this.chatRepository = chatRepository;
        this.chatAttachmentRepository = chatAttachmentRepository;
        this.viewClass = viewClass;
        this.fileInfoDialog = FileInfoDialogUtils.createFileInfoDialog((arg_0, arg_1) -> ((AiAssistantComponent)this).getTranslation(arg_0, arg_1));
        this.asyncRunner = asyncRunner;
        this.chatMessageContainer = new FileChatMessageContainer(this.createFileUploadComponent());
        this.addClassNames(new String[]{"w-full", "flex", "flex-auto"});
        this.setSpacing(false);
        this.setSizeFull();
        this.reset();
        this.setupStartNewChat();
        this.setupChatRating();
        this.setupChatMessageComponents();
    }

    protected void onDetach(DetachEvent detachEvent) {
        this.assistantCleanUp();
    }

    @Override
    public void startChatWithHistory(String chatId) {
        this.createChatSession(chatId);
        this.chatMessageContainer.scrollToEnd();
        this.startNewChat.setEnabled(true);
        this.chatRatingContainer.setVisible(true);
        this.chatMessageContainer.setInputEnabled(false);
    }

    private void reset() {
        this.assistantCleanUp();
        this.assistant = this.assistantApi.createAssistant(this.assistantPrompt);
        this.chatSession = this.createChat();
        this.startNewChat.setEnabled(false);
        this.chatRatingContainer.setVisible(false);
        this.chatMessageContainer.reset();
        this.fileIdByName.clear();
        if (this.upload != null) {
            this.upload.clearFileList();
        }
        this.chatMessageContainer.setInputEnabled(false);
        this.chatRating.setValue(null);
    }

    private void assistantCleanUp() {
        if (this.assistant != null) {
            this.assistant.close();
        }
    }

    private void saveMessage(ChatMessage.ChatMessageRole role, String message, Model<AssistantApi> model) {
        ChatMessage chatMessage = new ChatMessage(role, message, null, model);
        this.chatSession.addChatMessage(chatMessage);
        this.chatRepository.save(this.chatSession);
    }

    private void setupChatMessageComponents() {
        this.chatMessageContainer.addSubmitListener((ComponentEventListener<MessageInput.SubmitEvent>)((ComponentEventListener & Serializable)this::handleChatMessageInput));
        this.add(new Component[]{this.chatMessageContainer});
    }

    private Component createFileUploadComponent() {
        HorizontalLayout uploadLayout = new HorizontalLayout();
        MultiFileMemoryBuffer buffer = new MultiFileMemoryBuffer();
        this.upload = new Upload((Receiver)buffer);
        this.upload.getStyle().set("overflow", "unset");
        this.upload.setMaxFiles(10);
        int maxFileSizeInBytes = 0x1400000;
        this.upload.setMaxFileSize(maxFileSizeInBytes);
        UploadI18N i18n = UploadI18nFactory.getI18n((arg_0, arg_1) -> ((AiAssistantComponent)this).getTranslation(arg_0, arg_1), "20MB");
        this.upload.setI18n(i18n);
        this.upload.addFileRejectedListener((ComponentEventListener & Serializable)event -> {
            Notification notification = Notification.show((String)event.getErrorMessage(), (int)5000, (Notification.Position)Notification.Position.MIDDLE);
            notification.addThemeVariants((ThemeVariant[])new NotificationVariant[]{NotificationVariant.LUMO_ERROR});
        });
        this.upload.addSucceededListener((ComponentEventListener & Serializable)event -> {
            try {
                String filename = event.getFileName();
                InputStream inputStream = buffer.getInputStream(filename);
                AiFile aiFile = new AiFile(inputStream.readAllBytes(), event.getMIMEType(), event.getFileName());
                this.fileIdByName.put(filename, this.assistant.addFile(aiFile));
                this.addChatMessage(this.getTranslation("component.aiAssistant.fileAdded", new Object[]{filename}), "AI");
                this.chatMessageContainer.setInputEnabled(true);
            }
            catch (IOException e) {
                LOG.error("Failed handling file: {}", (Object)event.getFileName(), (Object)e);
                this.addChatMessage(this.getTranslation("component.aiAssistant.fileUploadFailed", new Object[0]), "AI");
            }
        });
        this.upload.getElement().addEventListener("file-remove", (DomEventListener & Serializable)event -> {
            JsonObject eventData = event.getEventData();
            String filename = eventData.getString("event.detail.file.name");
            String fileId = this.fileIdByName.remove(filename);
            if (fileId != null) {
                this.assistant.deleteFile(fileId);
            }
            if (this.fileIdByName.isEmpty()) {
                this.chatMessageContainer.setInputEnabled(false);
            }
            this.chatMessageContainer.addItem(this.getTranslation("component.aiAssistant.fileRemoved", new Object[]{filename}), "AI", false, false);
            this.chatMessageContainer.scrollToEnd();
        }).addEventData("event.detail.file.name");
        Button infoButton = new Button((Component)new Icon(VaadinIcon.INFO_CIRCLE));
        infoButton.addThemeVariants((ThemeVariant[])new ButtonVariant[]{ButtonVariant.LUMO_TERTIARY_INLINE, ButtonVariant.LUMO_ICON});
        infoButton.addClickListener((ComponentEventListener & Serializable)event -> this.fileInfoDialog.open());
        uploadLayout.add(new Component[]{this.upload, infoButton});
        return uploadLayout;
    }

    private void handleChatMessageInput(MessageInput.SubmitEvent event) {
        try (TypedAttribute.ValueRestorer c = CHAT_ID.setForScope((Object)this.chatSession.getChatId());){
            String text = event.getValue();
            if (text == null || text.isEmpty()) {
                return;
            }
            if (text.length() > this.maxLength) {
                Notification.show((String)this.getTranslation("common.messageTooLong", new Object[]{this.maxLength}), (int)6000, (Notification.Position)Notification.Position.MIDDLE);
                return;
            }
            if (!this.startNewChat.isEnabled()) {
                this.startNewChat.setEnabled(true);
            }
            this.chatRatingContainer.setVisible(true);
            this.addChatMessage(text, AuthUtils.getUsername());
            this.getUI().ifPresent(UI::push);
            this.handleChatMessage(text);
        }
    }

    private void setupStartNewChat() {
        this.startNewChat.addThemeVariants((ThemeVariant[])new ButtonVariant[]{ButtonVariant.LUMO_ICON});
        this.startNewChat.getStyle().setPosition(Style.Position.ABSOLUTE).setPaddingRight("5px").setZIndex(Integer.valueOf(1)).setFontSize("20px").setRight("70px").setTop("5px");
        this.startNewChat.setTooltipText(this.getTranslation("common.newChat", new Object[0]));
        this.startNewChat.addClickListener((ComponentEventListener & Serializable)event -> {
            UI.getCurrent().navigate(this.viewClass);
            this.reset();
        });
        this.startNewChat.setEnabled(false);
        this.chatRatingContainer.setVisible(false);
        this.add(new Component[]{this.startNewChat});
    }

    private void setupChatRating() {
        this.chatRating.addValueChangeListener(val -> {
            this.chatSession.setChatRating((Integer)val);
            this.chatRepository.save(this.chatSession);
        });
        this.chatRatingContainer.setWidthFull();
        this.chatRatingContainer.addClassNames(new String[]{"flex", "justify-end", "items-center"});
        Paragraph text = new Paragraph(this.getTranslation("common.rateChat", new Object[0]));
        text.addClassName("m-0");
        this.chatRatingContainer.add(new Component[]{text});
        this.chatRating.addClassName("pl-m");
        this.chatRatingContainer.add(new Component[]{this.chatRating});
        this.add(new Component[]{this.chatRatingContainer});
    }

    private void createChatSession(String chatId) {
        if (chatId == null) {
            return;
        }
        this.chatSession = this.chatRepository.findChatByChatIdAndUsername(chatId, AuthUtils.getEmail());
        if (this.chatSession != null) {
            this.chatSession.getChatMessages().stream().filter(m -> m.getRole() == ChatMessage.ChatMessageRole.ASSISTANT || m.getRole() == ChatMessage.ChatMessageRole.USER).forEach(m -> this.chatMessageContainer.addItem(m.getSendTime(), m.getMessage(), ChatUtils.inferUsername(this.chatSession, m), false, m.getRole() == ChatMessage.ChatMessageRole.ASSISTANT));
            this.getUI().ifPresent(UI::push);
        } else {
            this.chatSession = this.createChat();
        }
    }

    private void handleChatMessage(String text) {
        try (MessageChainUtils.MessageChain mc = MessageChainUtils.startMessageChain();){
            boolean isFirstChatMessage = this.chatSession.getChatMessages().isEmpty();
            if (isFirstChatMessage) {
                this.chatSession.setSummary(text.substring(0, Math.min(text.length(), 47)));
            }
            this.saveMessage(ChatMessage.ChatMessageRole.USER, text, (Model<AssistantApi>)this.assistantPrompt.model());
            this.handleResponse(this.assistant.ask(this.createAssistantQuestion(text)), (Model<AssistantApi>)this.assistantPrompt.model(), text, isFirstChatMessage);
        }
    }

    private String createAssistantQuestion(String text) {
        return "%s\n\nUploaded files: %s".formatted(text, this.fileIdByName.entrySet().stream().map(e -> "%s = %s".formatted(e.getKey(), e.getValue())).collect(Collectors.joining(",")));
    }

    private void handleResponse(AssistantResponse response, Model<AssistantApi> model, String text, boolean isFirstChatMessage) {
        StringBuilder builder = new StringBuilder();
        ArrayList contentList = new ArrayList();
        response.addSubscriber(r -> {
            contentList.add(r);
            if (r.content() != null) {
                builder.append(r.content());
                this.addChatMessage("%s...".formatted(builder.toString()), "AI", builder.length() > r.content().length(), false);
                this.getUI().ifPresent(UI::push);
            }
        });
        if (response.isSuccess() && !builder.isEmpty()) {
            String formattedMessage = AiAssistantComponent.handleAttachments(this.assistant.getProvider(), builder.toString(), contentList.stream().flatMap(c -> c.attachments().stream()).toList());
            this.addChatMessage(formattedMessage, "AI", true, true);
            this.getUI().ifPresent(UI::push);
            this.saveMessage(ChatMessage.ChatMessageRole.ASSISTANT, formattedMessage, model);
            if (isFirstChatMessage) {
                this.asyncRunner.run(() -> this.summarizeChat(text, builder.toString()), ContextUtils.getContext());
            }
        } else {
            this.saveMessage(ChatMessage.ChatMessageRole.ERROR, response.getResultState(), null);
        }
    }

    private static String handleAttachments(String provider, String message, List<OpenAiAssistantResponse.Attachment> attachments) {
        for (OpenAiAssistantResponse.Attachment attachment : attachments) {
            if (!OpenAiAssistantResponse.AttachmentType.FILE.equals((Object)attachment.type()) || attachment.anchor() == null || attachment.externalReference() == null) continue;
            String downloadLink = "/api/oai/file/%s?provider=%s&filename=%s".formatted(attachment.externalReference(), provider, AiAssistantComponent.parseFilename(attachment.anchor()));
            message = message.replaceAll("\\[(.*?)\\]\\((%s)\\)".formatted(Pattern.quote(attachment.anchor())), "[$1](%s)".formatted(downloadLink));
            message = message.replaceAll(Pattern.quote(attachment.anchor()), downloadLink);
        }
        return message;
    }

    private static String parseFilename(String anchor) {
        int startIndex = anchor.lastIndexOf(47);
        if (startIndex == -1) {
            return anchor;
        }
        if (startIndex == anchor.length() - 1) {
            return "";
        }
        return anchor.substring(startIndex + 1);
    }

    private void summarizeChat(String userMessage, String assistantResponse) {
        String summary;
        ChatPrompt.Builder builder = ChatPrompt.builder(this.summaryModel).add(Message.system((String)"Summarize the following conversation in less than 15 words. Ensure carefully that you understand the language of the question words the user is writing! This is the main language in which you MUST write the summary. The summary MUST be shorter than 15 words!")).add(Message.user((String)userMessage)).add(Message.assistant((String)assistantResponse));
        this.assistantPrompt.getStringProperty("provider").ifPresent(p -> builder.setParameter("provider", p));
        ChatResponse response = this.chatApi.send(builder.build());
        if (response.isSuccess() && (summary = (String)response.getMessage().map(Message::getContent).orElse(null)) != null) {
            this.chatSession.setSummary(summary);
            this.chatRepository.saveAndFlush(this.chatSession);
        }
    }

    private void addChatMessage(String messageText, String sender, boolean isReplacement, boolean convertToHtml) {
        this.chatMessageContainer.addItem(messageText, sender, isReplacement, convertToHtml);
        this.chatMessageContainer.scrollToEnd();
    }

    private void addChatMessage(String messageText, String sender) {
        this.addChatMessage(messageText, sender, false, false);
    }

    private Chat createChat() {
        return new Chat(this.chatType != null ? this.chatType : this.viewClass.getSimpleName());
    }
}

