/*
 * Decompiled with CFR 0.152.
 */
package fi.evolver.ai.vaadin.component;

import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.button.ButtonVariant;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.component.html.Paragraph;
import com.vaadin.flow.component.messages.MessageInput;
import com.vaadin.flow.component.notification.Notification;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.component.shared.ThemeVariant;
import com.vaadin.flow.dom.Style;
import fi.evolver.ai.spring.AsyncRunner;
import fi.evolver.ai.spring.Model;
import fi.evolver.ai.spring.chat.ChatApi;
import fi.evolver.ai.spring.chat.ChatResponse;
import fi.evolver.ai.spring.chat.prompt.ChatPrompt;
import fi.evolver.ai.spring.chat.prompt.Message;
import fi.evolver.ai.spring.provider.openai.OpenAiRequestGenerator;
import fi.evolver.ai.vaadin.ChatRepository;
import fi.evolver.ai.vaadin.PromptRepository;
import fi.evolver.ai.vaadin.component.ChatMessageContainer;
import fi.evolver.ai.vaadin.component.ChatSummaryPromptFunction;
import fi.evolver.ai.vaadin.component.StarRatingComponent;
import fi.evolver.ai.vaadin.entity.Chat;
import fi.evolver.ai.vaadin.entity.ChatMessage;
import fi.evolver.ai.vaadin.entity.Prompt;
import fi.evolver.ai.vaadin.util.AuthUtils;
import fi.evolver.ai.vaadin.util.ChatUtils;
import fi.evolver.ai.vaadin.view.HistoryAwareChat;
import fi.evolver.basics.spring.log.LogMetadataAttribute;
import fi.evolver.basics.spring.util.MessageChainUtils;
import fi.evolver.utils.ContextUtils;
import fi.evolver.utils.attribute.TypedAttribute;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import org.vaadin.lineawesome.LineAwesomeIcon;

public class AiChatComponent
extends VerticalLayout
implements HistoryAwareChat<Component> {
    private static final long serialVersionUID = 1L;
    public static final LogMetadataAttribute CHAT_ID = new LogMetadataAttribute("ChatId");
    private final List<Message> chatMessages = new ArrayList<Message>();
    private final Button startNewChat = new Button(LineAwesomeIcon.EDIT.create());
    private final StarRatingComponent chatRating = new StarRatingComponent((arg_0, arg_1) -> ((AiChatComponent)this).getTranslation(arg_0, arg_1));
    private final Div chatRatingContainer = new Div();
    private final ChatApi api;
    private final ChatRepository chatRepository;
    private final PromptRepository promptRepository;
    private final Class<? extends Component> viewClass;
    private final Optional<Function<String, ChatPrompt>> preprocessPromptCreator;
    private final Function<List<Message>, ChatPrompt> promptCreator;
    private final ChatSummaryPromptFunction chatSummaryPromptFunction;
    private final Function<ChatUtils.CommandType, Optional<String>> commandCreator;
    private final Optional<Function<String, String>> formatResponseFunction;
    private final AsyncRunner asyncRunner;
    private Chat chatSession;
    private int maxLength = Integer.MAX_VALUE;
    private String chatType;
    private ChatMessageContainer chatMessageContainer;

    public AiChatComponent(ChatApi api, ChatRepository chatRepository, PromptRepository promptRepository, Class<? extends Component> viewClass, Function<String, ChatPrompt> preprocessPromptCreator, Function<List<Message>, ChatPrompt> promptCreator, ChatSummaryPromptFunction chatSummaryFunction, Function<ChatUtils.CommandType, Optional<String>> commandCreator, Function<String, String> formatResponseFunction, AsyncRunner asyncRunner, ChatMessageContainer chatMessageContainer) {
        this.api = api;
        this.chatRepository = chatRepository;
        this.promptRepository = promptRepository;
        this.viewClass = viewClass;
        this.preprocessPromptCreator = Optional.ofNullable(preprocessPromptCreator);
        this.promptCreator = promptCreator;
        this.chatSummaryPromptFunction = chatSummaryFunction;
        this.commandCreator = commandCreator;
        this.formatResponseFunction = Optional.ofNullable(formatResponseFunction);
        this.asyncRunner = asyncRunner;
        this.chatMessageContainer = chatMessageContainer;
        this.addClassNames(new String[]{"w-full", "flex", "flex-auto", "overflow-hidden"});
        this.setSpacing(false);
        this.setSizeFull();
        this.reset();
        this.setupStartNewChat();
        this.setupChatRating();
        this.setupChatMessageComponents();
    }

    public AiChatComponent(ChatApi api, ChatRepository chatRepository, PromptRepository promptRepository, Class<? extends Component> viewClass, Function<String, ChatPrompt> preprocessPromptCreator, Function<List<Message>, ChatPrompt> promptCreator, ChatSummaryPromptFunction chatSummaryFunction, Function<ChatUtils.CommandType, Optional<String>> commandCreator, Function<String, String> formatResponseFunction, AsyncRunner asyncRunner) {
        this(api, chatRepository, promptRepository, viewClass, preprocessPromptCreator, promptCreator, chatSummaryFunction, commandCreator, formatResponseFunction, asyncRunner, new ChatMessageContainer());
    }

    public AiChatComponent(ChatApi api, ChatRepository chatRepository, PromptRepository promptRepository, Class<? extends Component> viewClass, Function<List<Message>, ChatPrompt> promptCreator, ChatSummaryPromptFunction chatSummaryFunction, AsyncRunner asyncRunner) {
        this(api, chatRepository, promptRepository, viewClass, null, promptCreator, chatSummaryFunction, c -> Optional.empty(), null, asyncRunner);
    }

    public AiChatComponent(ChatApi api, ChatRepository chatRepository, PromptRepository promptRepository, Class<? extends Component> viewClass, Function<String, ChatPrompt> preprocessPromptCreator, Function<List<Message>, ChatPrompt> promptCreator, AsyncRunner asyncRunner) {
        this(api, chatRepository, promptRepository, viewClass, preprocessPromptCreator, promptCreator, ChatUtils::createSummaryPrompt, c -> Optional.empty(), null, asyncRunner);
    }

    public AiChatComponent(ChatApi api, ChatRepository chatRepository, PromptRepository promptRepository, Class<? extends Component> viewClass, Function<List<Message>, ChatPrompt> promptCreator, AsyncRunner asyncRunner) {
        this(api, chatRepository, promptRepository, viewClass, null, promptCreator, ChatUtils::createSummaryPrompt, c -> Optional.empty(), null, asyncRunner);
    }

    protected void onAttach(AttachEvent attachEvent) {
        super.onAttach(attachEvent);
        this.chatMessageContainer.scrollToEnd();
    }

    @Override
    public void startChatWithHistory(String chatId) {
        this.createChatSession(chatId);
        this.startNewChat.setEnabled(true);
        this.chatRatingContainer.setVisible(true);
    }

    public void reset() {
        this.chatSession = this.createChat();
        this.startNewChat.setEnabled(false);
        this.chatRatingContainer.setVisible(false);
        this.chatMessages.clear();
        this.chatMessageContainer.reset();
        this.chatRating.setValue(null);
    }

    public void setInputEnabled(boolean enabled) {
        this.chatMessageContainer.setInputEnabled(enabled);
    }

    public void setMaxLength(int maxLength) {
        this.maxLength = maxLength;
    }

    public void setChatType(String chatType) {
        this.chatType = chatType;
        if (this.chatSession != null) {
            this.chatSession.setChatType(chatType);
        }
    }

    public Chat getChatSession() {
        return this.chatSession;
    }

    public void saveMessage(ChatMessage.ChatMessageRole role, String message, Prompt prompt, Model<ChatApi> model) {
        ChatMessage chatMessage = new ChatMessage(role, message, prompt, model);
        this.chatSession.addChatMessage(chatMessage);
        this.chatRepository.save(this.chatSession);
    }

    public void saveMessage(ChatMessage.ChatMessageRole role, String message) {
        this.saveMessage(role, message, null, null);
    }

    private void setupChatMessageComponents() {
        this.chatMessageContainer.addSubmitListener((ComponentEventListener<MessageInput.SubmitEvent>)((ComponentEventListener & Serializable)this::handleChatMessageInput));
        this.add(new Component[]{this.chatMessageContainer});
    }

    private void handleChatMessageInput(MessageInput.SubmitEvent event) {
        try (TypedAttribute.ValueRestorer c = CHAT_ID.setForScope((Object)this.chatSession.getChatId());){
            String text = event.getValue();
            if (text == null || text.isEmpty()) {
                return;
            }
            if (text.length() > this.maxLength) {
                Notification.show((String)this.getTranslation("common.messageTooLong", new Object[]{this.maxLength}), (int)6000, (Notification.Position)Notification.Position.MIDDLE);
                return;
            }
            if (!this.startNewChat.isEnabled()) {
                this.startNewChat.setEnabled(true);
            }
            this.chatRatingContainer.setVisible(true);
            this.showMessage(text, AuthUtils.getUsername());
            this.getUI().ifPresent(UI::push);
            Optional<ChatUtils.CommandType> command = ChatUtils.parseCommand(text);
            command.flatMap(this.commandCreator).ifPresentOrElse(this::displayCommandResponse, () -> this.handleChatMessage(text));
        }
    }

    private void setupStartNewChat() {
        this.startNewChat.addThemeVariants((ThemeVariant[])new ButtonVariant[]{ButtonVariant.LUMO_ICON});
        this.startNewChat.getStyle().setPosition(Style.Position.ABSOLUTE).setPaddingRight("5px").setZIndex(Integer.valueOf(1)).setFontSize("20px").setRight("70px").setTop("5px");
        this.startNewChat.setTooltipText(this.getTranslation("common.newChat", new Object[0]));
        this.startNewChat.addClickListener((ComponentEventListener & Serializable)event -> {
            UI.getCurrent().navigate(this.viewClass);
            this.reset();
        });
        this.startNewChat.setEnabled(false);
        this.chatRatingContainer.setVisible(false);
        this.add(new Component[]{this.startNewChat});
    }

    private void setupChatRating() {
        this.chatRating.addValueChangeListener(val -> {
            this.chatSession.setChatRating((Integer)val);
            this.chatRepository.save(this.chatSession);
        });
        this.chatRatingContainer.setWidthFull();
        this.chatRatingContainer.addClassNames(new String[]{"flex", "justify-end", "items-center"});
        Paragraph text = new Paragraph(this.getTranslation("common.rateChat", new Object[0]));
        text.addClassName("m-0");
        this.chatRatingContainer.add(new Component[]{text});
        this.chatRating.addClassName("pl-m");
        this.chatRatingContainer.add(new Component[]{this.chatRating});
        this.add(new Component[]{this.chatRatingContainer});
    }

    private void createChatSession(String chatId) {
        if (chatId == null) {
            return;
        }
        this.chatSession = this.chatRepository.findChatByChatIdAndUsername(chatId, AuthUtils.getEmail());
        if (this.chatSession != null) {
            this.chatSession.getChatMessages().stream().filter(m -> m.getRole() == ChatMessage.ChatMessageRole.ASSISTANT || m.getRole() == ChatMessage.ChatMessageRole.USER).forEach(m -> {
                this.chatMessageContainer.addItem(m.getSendTime(), m.getMessage(), ChatUtils.inferUsername(this.chatSession, m), false, m.getRole() == ChatMessage.ChatMessageRole.ASSISTANT);
                this.chatMessages.add(new Message(Message.Role.valueOf((String)m.getRole().name()), m.getMessage()));
            });
            this.chatRating.setValue(this.chatSession.getChatRating());
            this.getUI().ifPresent(UI::push);
        } else {
            this.chatSession = this.createChat();
        }
    }

    private void handleChatMessage(String message) {
        try (MessageChainUtils.MessageChain mc = MessageChainUtils.startMessageChain();){
            boolean isFirstChatMessage = !this.chatSession.hasMessages();
            String preprocessedInput = this.preprocessMessage(message);
            this.chatMessages.add(Message.user((String)preprocessedInput));
            ChatPrompt chatPrompt = this.promptCreator.apply(this.chatMessages);
            Prompt prompt = new Prompt(OpenAiRequestGenerator.generate((ChatPrompt)chatPrompt), chatPrompt.tokenCount());
            this.promptRepository.save(prompt);
            if (isFirstChatMessage) {
                chatPrompt.messages().stream().filter(m -> Message.Role.SYSTEM == m.getRole()).findFirst().ifPresent(s -> this.saveMessage(ChatMessage.ChatMessageRole.SYSTEM, s.getContent()));
                this.chatSession.setSummary("%s%s".formatted(message.substring(0, Math.min(message.length(), 47)), message.length() > 47 ? "..." : ""));
            }
            this.saveMessage(ChatMessage.ChatMessageRole.USER, message, prompt, (Model<ChatApi>)chatPrompt.model());
            String assistantResponse = this.handleResponse(this.api.send(chatPrompt), prompt, (Model<ChatApi>)chatPrompt.model());
            if (isFirstChatMessage) {
                this.asyncRunner.run(() -> this.summarizeChat(preprocessedInput, assistantResponse, chatPrompt), ContextUtils.getContext());
            }
        }
    }

    private String preprocessMessage(String message) {
        return this.preprocessPromptCreator.map(c -> this.api.send((ChatPrompt)c.apply(message))).filter(ChatResponse::isSuccess).flatMap(ChatResponse::getMessage).map(Message::getContent).orElse(message);
    }

    private String handleResponse(ChatResponse response, Prompt prompt, Model<ChatApi> model) {
        String assistantResponse = null;
        StringBuilder builder = new StringBuilder();
        response.addSubscriber(chunk -> {
            if (!chunk.isEmpty()) {
                builder.append(chunk);
                this.chatMessageContainer.addItem("%s...".formatted(builder.toString()), "AI", builder.length() > chunk.length(), false);
                this.chatMessageContainer.scrollToEnd();
                this.getUI().ifPresent(UI::push);
            }
        });
        if (response.isSuccess()) {
            assistantResponse = response.getMessage().map(Message::getContent).orElse(null);
            if (assistantResponse != null) {
                String finalAssistantResponse = assistantResponse;
                assistantResponse = this.formatResponseFunction.map(f -> (String)f.apply(finalAssistantResponse)).orElse(assistantResponse);
                this.chatMessageContainer.addItem(assistantResponse, "AI", true, true);
                this.chatMessages.add(Message.assistant((String)assistantResponse));
                this.chatMessageContainer.scrollToEnd();
                this.getUI().ifPresent(UI::push);
                this.saveMessage(ChatMessage.ChatMessageRole.ASSISTANT, assistantResponse, prompt, model);
            }
        } else {
            this.saveMessage(ChatMessage.ChatMessageRole.ERROR, response.getResultState());
        }
        return assistantResponse;
    }

    private void summarizeChat(String userMessage, String assistantResponse, ChatPrompt chatPrompt) {
        ChatPrompt summaryPrompt = this.chatSummaryPromptFunction.apply((Model<ChatApi>)chatPrompt.model(), chatPrompt.getStringProperty("provider"), userMessage, assistantResponse);
        ChatResponse response = this.api.send(summaryPrompt);
        if (response.isSuccess()) {
            response.getMessage().map(Message::getContent).ifPresent(summary -> {
                this.chatSession.setSummary((String)summary);
                this.chatRepository.saveAndFlush(this.chatSession);
            });
        }
    }

    private void displayCommandResponse(String commandResponse) {
        this.showMessage(commandResponse, "AI");
        this.getUI().ifPresent(UI::push);
    }

    private void showMessage(String messageText, String sender) {
        this.chatMessageContainer.addItem(messageText, sender, false, false);
        this.chatMessageContainer.scrollToEnd();
    }

    private Chat createChat() {
        return new Chat(this.chatType != null ? this.chatType : this.viewClass.getSimpleName());
    }
}

