/*
 * Decompiled with CFR 0.152.
 */
package fi.evolver.ai.vaadin.component;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.ScrollOptions;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.component.html.Image;
import com.vaadin.flow.component.html.Paragraph;
import com.vaadin.flow.component.messages.MessageInput;
import com.vaadin.flow.component.messages.MessageList;
import com.vaadin.flow.component.messages.MessageListItem;
import com.vaadin.flow.component.notification.Notification;
import com.vaadin.flow.component.orderedlayout.FlexComponent;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.component.select.Select;
import com.vaadin.flow.server.AbstractStreamResource;
import com.vaadin.flow.server.InputStreamFactory;
import com.vaadin.flow.server.StreamResource;
import fi.evolver.ai.spring.ApiResponseException;
import fi.evolver.ai.spring.Model;
import fi.evolver.ai.spring.chat.prompt.Message;
import fi.evolver.ai.spring.image.ImageApi;
import fi.evolver.ai.spring.image.ImageResponse;
import fi.evolver.ai.spring.image.prompt.ImageGenerationPrompt;
import fi.evolver.ai.spring.provider.openai.OpenAiRequestGenerator;
import fi.evolver.ai.spring.provider.openai.OpenAiService;
import fi.evolver.ai.vaadin.ChatAttachmentRepository;
import fi.evolver.ai.vaadin.ChatRepository;
import fi.evolver.ai.vaadin.PromptRepository;
import fi.evolver.ai.vaadin.component.AiChatComponent;
import fi.evolver.ai.vaadin.component.StarRatingComponent;
import fi.evolver.ai.vaadin.component.i18n.MessageInputI18nFactory;
import fi.evolver.ai.vaadin.entity.Chat;
import fi.evolver.ai.vaadin.entity.ChatAttachment;
import fi.evolver.ai.vaadin.entity.ChatMessage;
import fi.evolver.ai.vaadin.entity.Prompt;
import fi.evolver.ai.vaadin.util.AuthUtils;
import fi.evolver.ai.vaadin.util.ChatUtils;
import fi.evolver.ai.vaadin.view.HistoryAwareChat;
import fi.evolver.utils.NullSafetyUtils;
import fi.evolver.utils.attribute.TypedAttribute;
import java.io.ByteArrayInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import org.vaadin.olli.FileDownloadWrapper;

public class AiImageComponent
extends VerticalLayout
implements HistoryAwareChat<Component> {
    private static final long serialVersionUID = 1L;
    private static final List<String> STYLES = List.of("natural", "vivid");
    private static final List<String> SIZES = List.of("1024x1024", "1024x1792", "1792x1024");
    private static final List<String> QUALITIES = List.of("standard", "hd");
    private static final int MAX_LENGTH = 1000;
    private final MessageInput chatMessageInput = new MessageInput();
    private final MessageList chatMessageList = new MessageList();
    private final List<Message> chatMessages = new ArrayList<Message>();
    private final Button startNewChat = new Button();
    private final StarRatingComponent chatRating = new StarRatingComponent((arg_0, arg_1) -> ((AiImageComponent)this).getTranslation(arg_0, arg_1));
    private final Div chatRatingContainer = new Div();
    private final Button downloadImageButton = new Button();
    private final Button recreateImageButton = new Button();
    private final ImageApi api;
    private final ChatRepository chatRepository;
    private final PromptRepository promptRepository;
    private final ChatAttachmentRepository chatAttachmentRepository;
    private final Class<? extends Component> viewClass;
    private FileDownloadWrapper buttonWrapper;
    private Select<String> qualitySelect;
    private Select<String> sizeSelect;
    private Select<String> styleSelect;
    private String promptText;
    private Image image;
    private Chat chatSession;
    private String chatType;

    public AiImageComponent(ImageApi api, ChatRepository chatRepository, PromptRepository promptRepository, ChatAttachmentRepository chatAttachmentRepository, Class<? extends Component> viewClass) {
        this.api = api;
        this.chatRepository = chatRepository;
        this.promptRepository = promptRepository;
        this.chatAttachmentRepository = chatAttachmentRepository;
        this.viewClass = viewClass;
        this.addClassNames(new String[]{"w-full", "flex", "flex-auto"});
        this.setSpacing(false);
        this.setSizeFull();
        this.reset();
        this.setupStartNewChatButton();
        this.setupChatRating();
        this.setupImageRequestOptions();
        this.setupChatMessageComponents();
        this.setupRecreateImageButton();
    }

    @Override
    public void startChatWithHistory(String chatId) {
        this.createChatSession(chatId);
        this.startNewChat.setEnabled(true);
        this.chatRatingContainer.setVisible(true);
        this.chatMessageInput.scrollIntoView(new ScrollOptions(ScrollOptions.Behavior.SMOOTH));
    }

    private void reset() {
        this.chatSession = this.createChat();
        this.startNewChat.setEnabled(false);
        this.chatRatingContainer.setVisible(false);
        this.recreateImageButton.setVisible(false);
        this.chatMessages.clear();
        this.chatMessageList.setItems(new MessageListItem[0]);
        this.chatRating.setValue(null);
        if (this.image != null && this.image.isAttached()) {
            this.remove(new Component[]{this.image});
        }
        this.toggleSelectInputs(true);
        this.setDefaultSelectValues();
        this.displayChatMessageInput(true);
        this.displayDownload(false);
    }

    private void disableImageGenerationInputs() {
        this.displayChatMessageInput(false);
        this.toggleSelectInputs(false);
    }

    private void displayChatMessageInput(boolean isVisible) {
        this.chatMessageInput.setVisible(isVisible);
    }

    private void displayDownload(boolean isVisible) {
        this.downloadImageButton.setVisible(isVisible);
        if (this.buttonWrapper != null) {
            this.buttonWrapper.setVisible(isVisible);
        }
    }

    private void saveMessage(ChatMessage.ChatMessageRole role, String message, Prompt prompt, Model<?> model) {
        ChatMessage chatMessage = new ChatMessage(role, message, prompt, model);
        chatMessage.setTokenCount(null);
        this.chatSession.addChatMessage(chatMessage);
    }

    private void saveMessage(ChatMessage.ChatMessageRole role, String message) {
        this.saveMessage(role, message, null, null);
    }

    private void createChatSession(String chatId) {
        if (chatId == null) {
            return;
        }
        this.chatSession = this.chatRepository.findChatByChatIdAndUsername(chatId, AuthUtils.getEmail());
        if (this.chatSession != null) {
            ArrayList existingMessages = new ArrayList();
            this.chatSession.getChatMessages().stream().filter(m -> m.getRole() == ChatMessage.ChatMessageRole.ASSISTANT || m.getRole() == ChatMessage.ChatMessageRole.USER).forEach(m -> {
                existingMessages.add(new MessageListItem(m.getMessage(), ChatUtils.convertToInstantFi(m.getSendTime()), AiImageComponent.inferUsername(this.chatSession, m)));
                this.chatMessages.add(new Message(Message.Role.valueOf((String)m.getRole().name()), m.getMessage()));
            });
            this.chatSession.getChatMessages().stream().filter(m -> m.getRole() == ChatMessage.ChatMessageRole.USER).findFirst().ifPresent(cm -> {
                this.promptText = cm.getMessage();
            });
            this.chatMessageList.setItems(existingMessages);
            this.disableImageGenerationInputs();
            this.startNewChat.setEnabled(false);
            this.chatRatingContainer.setVisible(false);
            ChatAttachment chatAttachment = this.chatAttachmentRepository.findChatAttachmentByChat(this.chatSession);
            if (chatAttachment != null) {
                byte[] imageData = chatAttachment.getData();
                StreamResource resource = new StreamResource("image.png", (InputStreamFactory & Serializable)() -> new ByteArrayInputStream(imageData));
                this.image = new Image((AbstractStreamResource)resource, "image");
                this.add(new Component[]{this.image});
                this.handleDownloadingImage(imageData);
                this.recreateImageButton.setVisible(true);
            }
            this.getUI().ifPresent(UI::push);
        } else {
            this.chatSession = this.createChat();
        }
    }

    private void setupChatMessageComponents() {
        this.chatMessageInput.setI18n(MessageInputI18nFactory.getI18nForImageComponent((arg_0, arg_1) -> ((AiImageComponent)this).getTranslation(arg_0, arg_1)));
        this.chatMessageInput.addSubmitListener(this::handleChatMessageInput);
        this.chatMessageInput.setWidthFull();
        this.chatMessageList.setSizeFull();
        VerticalLayout chatContainer = new VerticalLayout();
        chatContainer.addClassNames(new String[]{"flex-auto", "overflow-hidden"});
        chatContainer.add(new Component[]{this.chatMessageList, this.chatMessageInput});
        this.add(new Component[]{chatContainer});
        this.expand(new Component[]{this.chatMessageList});
    }

    private void setupImageRequestOptions() {
        this.sizeSelect = AiImageComponent.createSelect(this.getTranslation("component.aiImage.sizeSelect", new Object[0]), SIZES);
        this.qualitySelect = AiImageComponent.createSelect(this.getTranslation("component.aiImage.qualitySelect", new Object[0]), QUALITIES);
        this.styleSelect = AiImageComponent.createSelect(this.getTranslation("component.aiImage.styleSelect", new Object[0]), STYLES);
        this.setDefaultSelectValues();
        HorizontalLayout selectContainer = new HorizontalLayout();
        selectContainer.setDefaultVerticalComponentAlignment(FlexComponent.Alignment.AUTO);
        selectContainer.add(new Component[]{this.sizeSelect, this.qualitySelect, this.styleSelect});
        selectContainer.setSpacing(true);
        this.add(new Component[]{selectContainer});
    }

    private static Select<String> createSelect(String label, List<String> items) {
        Select select = new Select();
        select.setLabel(label);
        select.setItems(items);
        select.setWidthFull();
        return select;
    }

    private void setDefaultSelectValues() {
        if (this.sizeSelect != null) {
            this.sizeSelect.setValue((Object)SIZES.get(0));
        }
        if (this.qualitySelect != null) {
            this.qualitySelect.setValue((Object)QUALITIES.get(0));
        }
        if (this.styleSelect != null) {
            this.styleSelect.setValue((Object)STYLES.get(0));
        }
    }

    private void toggleSelectInputs(boolean isEnabled) {
        if (this.sizeSelect != null) {
            this.sizeSelect.setEnabled(isEnabled);
        }
        if (this.qualitySelect != null) {
            this.qualitySelect.setEnabled(isEnabled);
        }
        if (this.styleSelect != null) {
            this.styleSelect.setEnabled(isEnabled);
        }
    }

    private void handleChatMessageInput(MessageInput.SubmitEvent event) {
        try (TypedAttribute.ValueRestorer c = AiChatComponent.CHAT_ID.setForScope((Object)this.chatSession.getChatId());){
            this.promptText = event.getValue();
            if (this.promptText == null || this.promptText.isEmpty()) {
                return;
            }
            if (this.promptText.length() > 1000) {
                Notification.show((String)this.getTranslation("common.messageTooLong", new Object[]{1000}), (int)6000, (Notification.Position)Notification.Position.MIDDLE);
                return;
            }
            if (!this.startNewChat.isEnabled()) {
                this.startNewChat.setEnabled(true);
            }
            this.chatRatingContainer.setVisible(true);
            this.disableImageGenerationInputs();
            this.showMessage(this.promptText, AuthUtils.getUsername());
            this.getUI().ifPresent(UI::push);
            this.handleImageRequest(this.promptText);
        }
    }

    private void handleImageRequest(String userMessage) {
        this.chatMessages.add(Message.user((String)userMessage));
        ImageGenerationPrompt imagePrompt = ImageGenerationPrompt.builder((Model)OpenAiService.DALL_E_3).setPrompt(userMessage).setParameter("quality", this.qualitySelect.getValue()).setParameter("size", this.sizeSelect.getValue()).setParameter("style", this.styleSelect.getValue()).build();
        Prompt prompt = new Prompt(OpenAiRequestGenerator.generate((ImageGenerationPrompt)imagePrompt), null);
        this.promptRepository.save(prompt);
        this.saveMessage(ChatMessage.ChatMessageRole.USER, userMessage, prompt, imagePrompt.model());
        try {
            byte[] imageResponseBytes = this.handleResponse(this.api.send(imagePrompt), prompt, imagePrompt.model());
            if (imageResponseBytes != null) {
                ChatAttachment chatAttachment = new ChatAttachment("image/png", imageResponseBytes, imagePrompt.provider(), this.chatSession);
                this.handleDownloadingImage(imageResponseBytes);
                this.chatAttachmentRepository.save(chatAttachment);
                this.recreateImageButton.setVisible(this.isVisible());
            }
        }
        catch (ApiResponseException e) {
            this.showMessage(this.getTranslation("component.aiImage.generationFailed", new Object[0]), "AI");
            this.saveMessage(ChatMessage.ChatMessageRole.ERROR, "ERROR");
            this.chatSession.setSummary(this.getTranslation("component.aiImage.generationFailed", new Object[0]));
            this.chatRepository.save(this.chatSession);
        }
        this.startNewChat.setEnabled(true);
        this.chatRatingContainer.setVisible(true);
    }

    private byte[] handleResponse(ImageResponse response, Prompt prompt, Model<?> model) {
        if (response.getImage() == null) {
            return null;
        }
        this.chatMessages.add(Message.assistant((String)this.getTranslation("component.aiImage.generationSuccess", new Object[0])));
        this.showMessage(this.getTranslation("component.aiImage.generationSuccess", new Object[0]), "AI");
        byte[] imageBytes = response.getImage().data();
        StreamResource resource = new StreamResource("image.png", (InputStreamFactory & Serializable)() -> new ByteArrayInputStream(imageBytes));
        this.image = new Image((AbstractStreamResource)resource, "image");
        this.add(new Component[]{this.image});
        this.getUI().ifPresent(UI::push);
        this.saveMessage(ChatMessage.ChatMessageRole.ASSISTANT, this.getTranslation("component.aiImage.generationSuccess", new Object[0]), prompt, model);
        this.chatSession.setSummary(this.getTranslation("component.aiImage.generationSuccess", new Object[0]));
        this.chatRepository.save(this.chatSession);
        return imageBytes;
    }

    private void handleDownloadingImage(byte[] imageBytes) {
        this.displayDownload(true);
        this.downloadImageButton.setText(this.getTranslation("component.aiImage.downloadImage", new Object[0]));
        this.downloadImageButton.getStyle().setMarginTop("15px");
        if (this.buttonWrapper == null) {
            this.buttonWrapper = new FileDownloadWrapper(new StreamResource("image.png", (InputStreamFactory & Serializable)() -> new ByteArrayInputStream(imageBytes)));
        } else {
            this.buttonWrapper.setResource(new StreamResource("image.png", (InputStreamFactory & Serializable)() -> new ByteArrayInputStream(imageBytes)));
        }
        this.buttonWrapper.wrapComponent((Component)this.downloadImageButton);
        this.buttonWrapper.setVisible(true);
        this.add(new Component[]{this.buttonWrapper});
    }

    private void setupStartNewChatButton() {
        this.startNewChat.setText(this.getTranslation("component.aiImage.reset", new Object[0]));
        this.startNewChat.addClickListener((ComponentEventListener & Serializable)event -> {
            UI.getCurrent().navigate(this.viewClass);
            this.reset();
        });
        this.startNewChat.setEnabled(false);
        this.chatRatingContainer.setVisible(false);
        this.add(new Component[]{this.startNewChat});
    }

    private void setupChatRating() {
        this.chatRating.addValueChangeListener(val -> {
            this.chatSession.setChatRating((Integer)val);
            this.chatRepository.save(this.chatSession);
        });
        this.chatRatingContainer.setWidthFull();
        this.chatRatingContainer.addClassNames(new String[]{"flex", "justify-end", "items-center"});
        Paragraph text = new Paragraph(this.getTranslation("common.rateChat", new Object[0]));
        text.addClassName("m-0");
        this.chatRatingContainer.add(new Component[]{text});
        this.chatRating.addClassName("pl-m");
        this.chatRatingContainer.add(new Component[]{this.chatRating});
        this.add(new Component[]{this.chatRatingContainer});
    }

    private void setupRecreateImageButton() {
        this.recreateImageButton.setText(this.getTranslation("component.aiImage.recreateImage", new Object[0]));
        this.recreateImageButton.addClickListener((ComponentEventListener & Serializable)event -> {
            this.reset();
            this.disableImageGenerationInputs();
            this.showMessage(this.getTranslation("component.aiImage.generating", new Object[0]), "AI");
            UI.getCurrent().push();
            this.handleImageRequest(this.promptText);
        });
        this.recreateImageButton.getStyle().setMarginBottom("15px");
        this.recreateImageButton.setVisible(this.image != null && this.image.isAttached());
        this.add(new Component[]{this.recreateImageButton});
    }

    private void showMessage(String messageText, String sender) {
        MessageListItem message = new MessageListItem(messageText, ChatUtils.currentTimeHelsinki(), sender);
        this.chatMessageList.setItems(Stream.concat(this.chatMessageList.getItems().stream(), Stream.of(message)).toList());
    }

    private Chat createChat() {
        return new Chat(this.chatType != null ? this.chatType : this.viewClass.getSimpleName());
    }

    private static String inferUsername(Chat chat, ChatMessage message) {
        return switch (message.getRole()) {
            case ChatMessage.ChatMessageRole.ASSISTANT -> "AI";
            case ChatMessage.ChatMessageRole.USER -> (String)NullSafetyUtils.denull((Object[])new String[]{chat.getDisplayName(), "User"});
            default -> "Unknown";
        };
    }
}

