/*
 * Decompiled with CFR 0.152.
 */
package fi.evolver.ai.vaadin.component;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.Composite;
import com.vaadin.flow.component.HasSize;
import com.vaadin.flow.component.HasText;
import com.vaadin.flow.component.Html;
import com.vaadin.flow.component.avatar.Avatar;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.orderedlayout.FlexComponent;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import fi.evolver.ai.vaadin.util.ChatUtils;
import fi.evolver.utils.DateUtils;
import java.time.LocalDateTime;

public class ChatAvatarItem
extends Composite<HorizontalLayout>
implements HasSize {
    private static final long serialVersionUID = 1L;

    public ChatAvatarItem(LocalDateTime sendTime, String message, String user, boolean convertToHtml) {
        ((HorizontalLayout)this.getContent()).setAlignItems(FlexComponent.Alignment.START);
        VerticalLayout column = new VerticalLayout(new Component[]{ChatAvatarItem.generateHeader(sendTime, user), ChatAvatarItem.generateMessage(message, convertToHtml)});
        column.setPadding(false);
        column.setSpacing(false);
        ((HorizontalLayout)this.getContent()).add(new Component[]{column});
        ((HorizontalLayout)this.getContent()).getStyle().set("line-height", "var(--lumo-line-height-m)");
        ((HorizontalLayout)this.getContent()).addComponentAsFirst((Component)new Avatar(user));
    }

    private static Div generateHeader(LocalDateTime sendTime, String user) {
        Div result = new Div();
        Span userPart = new Span(user);
        userPart.getStyle().set("margin-right", "var(--lumo-space-s)");
        Span dateTimePart = new Span(sendTime.format(DateUtils.FORMAT_DATE_TIME_FI));
        dateTimePart.getStyle().set("color", "var(--lumo-secondary-text-color)").set("font-size", "var(--lumo-font-size-s)");
        result.add(new Component[]{userPart, dateTimePart});
        return result;
    }

    private static Component generateMessage(String message, boolean convertToHtml) {
        if (convertToHtml) {
            return new Html(ChatUtils.convertToHtml(message));
        }
        Div div = new Div(message);
        div.setWhiteSpace(HasText.WhiteSpace.PRE_WRAP);
        return div;
    }
}

