/*
 * Decompiled with CFR 0.152.
 */
package fi.evolver.ai.vaadin.component;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.Composite;
import com.vaadin.flow.component.HasSize;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.avatar.Avatar;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.icon.Icon;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.orderedlayout.FlexComponent;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.router.QueryParameters;
import fi.evolver.ai.vaadin.ChatHistoryConfiguration;
import fi.evolver.ai.vaadin.component.StarRatingComponent;
import fi.evolver.ai.vaadin.entity.Chat;
import fi.evolver.ai.vaadin.entity.ChatMessage;
import fi.evolver.ai.vaadin.view.ChatHistoryAction;
import fi.evolver.utils.DateUtils;
import java.io.Serializable;
import java.util.List;
import java.util.Map;

public class ChatHistoryAvatarItem
extends Composite<HorizontalLayout>
implements HasSize {
    private static final long serialVersionUID = 1L;
    private final Chat chat;
    private final ChatHistoryAction historyAction;
    private final ChatHistoryConfiguration config;

    public ChatHistoryAvatarItem(Chat chat, ChatHistoryConfiguration config, ChatHistoryAction historyAction) {
        this.chat = chat;
        this.historyAction = historyAction;
        this.config = config;
        this.generateContent();
    }

    private void generateContent() {
        HorizontalLayout containerLayout = new HorizontalLayout();
        ((HorizontalLayout)this.getContent()).setAlignItems(FlexComponent.Alignment.CENTER);
        Span headingDate = new Span(this.chat.getStartTime().format(DateUtils.FORMAT_DATE_TIME_FI));
        Span headingSummary = new Span(this.chat.getSummary());
        Span description = new Span(ChatHistoryAvatarItem.getDescription(this.chat.getChatMessages()));
        description.getStyle().set("color", "var(--lumo-secondary-text-color)").set("font-size", "var(--lumo-font-size-s)");
        headingDate.addClassName("font-bold");
        VerticalLayout chatLayout = new VerticalLayout(new Component[]{headingDate, headingSummary, description});
        chatLayout.setPadding(false);
        chatLayout.setSpacing(false);
        chatLayout.setWidth("500px");
        chatLayout.addClickListener((ComponentEventListener & Serializable)e -> this.handleOnClickEvent());
        containerLayout.setWidth("600px");
        containerLayout.setAlignItems(FlexComponent.Alignment.CENTER);
        containerLayout.add(new Component[]{chatLayout, this.createFavoriteIcon(), this.createEditChatSummaryIcon(), this.createRemoveChatIcon(), this.createChatRatingButton()});
        ((HorizontalLayout)this.getContent()).add(new Component[]{containerLayout});
        ((HorizontalLayout)this.getContent()).getStyle().set("line-height", "var(--lumo-line-height-m)");
        ((HorizontalLayout)this.getContent()).getStyle().setCursor("pointer");
        this.setAvatar(new Avatar());
    }

    private Icon createRemoveChatIcon() {
        Icon icon = VaadinIcon.TRASH.create();
        icon.setTooltipText(this.getTranslation("component.chatHistoryAvatarItem.removeChat", new Object[0]));
        icon.addClickListener((ComponentEventListener & Serializable)e -> this.historyAction.showRemovalDialog(this.chat));
        return icon;
    }

    private Icon createEditChatSummaryIcon() {
        Icon icon = VaadinIcon.EDIT.create();
        icon.setTooltipText(this.getTranslation("component.chatHistoryAvatarItem.renameChat", new Object[0]));
        icon.addClickListener((ComponentEventListener & Serializable)e -> this.historyAction.showEditDialog(this.chat));
        return icon;
    }

    private Icon createFavoriteIcon() {
        Icon icon = this.chat.isFavorite() ? VaadinIcon.STAR.create() : VaadinIcon.STAR_O.create();
        icon.setTooltipText(this.chat.isFavorite() ? this.getTranslation("component.chatHistoryAvatarItem.removeFromFavorites", new Object[0]) : this.getTranslation("component.chatHistoryAvatarItem.saveToFavorites", new Object[0]));
        icon.addClickListener((ComponentEventListener & Serializable)e -> this.historyAction.toggleFavorite(this.chat));
        return icon;
    }

    private StarRatingComponent createChatRatingButton() {
        StarRatingComponent rating = new StarRatingComponent(this.chat.getChatRating(), (arg_0, arg_1) -> ((ChatHistoryAvatarItem)this).getTranslation(arg_0, arg_1));
        rating.addValueChangeListener(val -> this.historyAction.setChatRating(this.chat, (Integer)val));
        rating.addClassName("pl-s");
        return rating;
    }

    private void handleOnClickEvent() {
        UI.getCurrent().navigate(this.config.route(), new QueryParameters(Map.of("chatId", List.of(this.chat.getChatId()))));
    }

    public void setAvatar(Avatar avatar) {
        Component component = ((HorizontalLayout)this.getContent()).getComponentAt(0);
        if (component instanceof Avatar) {
            Avatar existing = (Avatar)component;
            existing.removeFromParent();
        }
        ((HorizontalLayout)this.getContent()).addComponentAsFirst((Component)avatar);
    }

    private static String getDescription(List<ChatMessage> messages) {
        ChatMessage message = messages.stream().filter(m -> m.getRole() == ChatMessage.ChatMessageRole.USER).findFirst().orElse(messages.get(0));
        if (message == null || message.getMessage() == null) {
            return "";
        }
        return message.getMessage().length() > 150 ? "%s...".formatted(message.getMessage().substring(0, 150)) : message.getMessage();
    }
}

