/*
 * Decompiled with CFR 0.152.
 */
package fi.evolver.ai.vaadin.component;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.messages.MessageInput;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import fi.evolver.ai.vaadin.component.ChatMessageList;
import fi.evolver.ai.vaadin.component.i18n.MessageInputI18nFactory;
import java.io.Serializable;
import java.time.LocalDateTime;

public class ChatMessageContainer
extends VerticalLayout {
    private static final long serialVersionUID = 1L;
    protected final MessageInput chatMessageInput = new MessageInput();
    protected final ChatMessageList chatMessageList = new ChatMessageList();

    protected ChatMessageContainer(Boolean addComponents) {
        if (addComponents.booleanValue()) {
            this.addComponents();
        }
    }

    public ChatMessageContainer() {
        this(true);
    }

    protected void addComponents() {
        this.addClassNames(new String[]{"w-full", "flex", "flex-auto"});
        this.setSizeFull();
        this.addClassNames(new String[]{"flex-auto", "overflow-hidden"});
        this.addMessageList();
        this.addInputs();
    }

    protected void addMessageList() {
        this.chatMessageList.setId("chat-message-list-container");
        this.chatMessageList.setSizeFull();
        this.add(new Component[]{this.chatMessageList});
        this.expand(new Component[]{this.chatMessageList});
    }

    protected void addInputs() {
        this.chatMessageInput.setI18n(MessageInputI18nFactory.getI18n((arg_0, arg_1) -> ((ChatMessageContainer)this).getTranslation(arg_0, arg_1)));
        this.chatMessageInput.setWidthFull();
        this.add(new Component[]{this.chatMessageInput});
    }

    public void reset() {
        this.chatMessageList.reset();
    }

    public void setInputEnabled(Boolean enabled) {
        this.chatMessageInput.setEnabled(enabled.booleanValue());
    }

    public void addSubmitListener(ComponentEventListener<MessageInput.SubmitEvent> listener) {
        this.chatMessageInput.addSubmitListener(listener);
    }

    public void addItem(LocalDateTime sendTime, String message, String user, boolean isReplacement, boolean convertToHtml) {
        this.chatMessageList.addItem(sendTime, message, user, isReplacement, convertToHtml);
    }

    public void addItem(String message, String user, boolean isReplacement, boolean convertToHtml) {
        this.addItem(LocalDateTime.now(), message, user, isReplacement, convertToHtml);
    }

    public void scrollToEnd() {
        this.getElement().executeJs("\tconst el = document.getElementById(\"chat-message-list-container\");\n\tel.scrollTo(0, el.scrollHeight);\n", new Serializable[0]);
    }
}

