/*
 * Decompiled with CFR 0.152.
 */
package fi.evolver.ai.vaadin.component;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasComponents;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.dom.Style;
import fi.evolver.ai.vaadin.component.ChatAvatarItem;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;

public class ChatMessageList
extends VerticalLayout
implements HasComponents {
    private static final long serialVersionUID = 1L;
    private List<ChatAvatarItem> chatItems = new ArrayList<ChatAvatarItem>();

    public ChatMessageList() {
        this.addClassNames(new String[]{"flex-auto"});
        this.getStyle().set("overflow-x", "hidden").set("overflow-y", "scroll").setPaddingRight("17px").setBoxSizing(Style.BoxSizing.CONTENT_BOX);
    }

    public void addItem(LocalDateTime sendTime, String message, String user, boolean isReplacement, boolean convertToHtml) {
        if (isReplacement) {
            ChatAvatarItem replacableItem = !this.chatItems.isEmpty() ? this.chatItems.remove(this.chatItems.size() - 1) : null;
            this.remove(new Component[]{replacableItem});
        }
        ChatAvatarItem item = new ChatAvatarItem(sendTime, message, user, convertToHtml);
        this.chatItems.add(item);
        this.add(new Component[]{item});
    }

    public void addItem(String message, String user, boolean isReplacement, boolean convertToHtml) {
        this.addItem(LocalDateTime.now(), message, user, isReplacement, convertToHtml);
    }

    public void addItem(String message, String user) {
        this.addItem(message, user, false, false);
    }

    public void reset() {
        this.chatItems.clear();
        this.removeAll();
    }
}

