/*
 * Decompiled with CFR 0.152.
 */
package fi.evolver.ai.vaadin.component;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.Html;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.button.ButtonVariant;
import com.vaadin.flow.component.dialog.Dialog;
import com.vaadin.flow.component.html.H2;
import com.vaadin.flow.component.orderedlayout.FlexComponent;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.component.shared.ThemeVariant;
import fi.evolver.ai.vaadin.component.i18n.VaadinTranslations;
import java.io.Serializable;

public class FileInfoDialogUtils {
    private FileInfoDialogUtils() {
    }

    public static Dialog createFileInfoDialog(VaadinTranslations t) {
        Dialog dialog = new Dialog();
        dialog.getElement().setAttribute("aria-label", UI.getCurrent().getTranslation("component.fileInfoDialog.label", new Object[0]));
        VerticalLayout dialogLayout = FileInfoDialogUtils.createDialogLayout(dialog, t);
        dialog.add(new Component[]{dialogLayout});
        return dialog;
    }

    private static VerticalLayout createDialogLayout(Dialog dialog, VaadinTranslations t) {
        VerticalLayout dialogLayout = FileInfoDialogUtils.createDialogBaseLayout(t);
        Button confirmButton = new Button("OK", (ComponentEventListener & Serializable)e -> dialog.close());
        confirmButton.addThemeVariants((ThemeVariant[])new ButtonVariant[]{ButtonVariant.LUMO_PRIMARY});
        HorizontalLayout buttonLayout = new HorizontalLayout(new Component[]{confirmButton});
        buttonLayout.setJustifyContentMode(FlexComponent.JustifyContentMode.CENTER);
        dialogLayout.add(new Component[]{buttonLayout});
        return dialogLayout;
    }

    public static VerticalLayout createDialogBaseLayout(VaadinTranslations t) {
        H2 heading = new H2(t.getTranslation("component.fileInfoDialog.title", new Object[0]));
        heading.getStyle().set("margin", "var(--lumo-space-m) 0 0 0").set("font-size", "1.5em").set("font-weight", "bold");
        VerticalLayout contentLayout = new VerticalLayout(new Component[]{new Html(FileInfoDialogUtils.createDialogContent(t))});
        contentLayout.setSpacing(false);
        contentLayout.setPadding(false);
        contentLayout.setAlignItems(FlexComponent.Alignment.STRETCH);
        VerticalLayout dialogLayout = new VerticalLayout(new Component[]{heading, contentLayout});
        dialogLayout.setPadding(false);
        dialogLayout.setAlignItems(FlexComponent.Alignment.STRETCH);
        dialogLayout.getStyle().set("width", "300px").set("max-width", "100%");
        return dialogLayout;
    }

    private static String createDialogContent(VaadinTranslations t) {
        return "<div>\n\t<p>%s</p>\n\t<p><i>.c, .cpp, .css, .csv, .docx, .gif, .html, .java, .jpeg, .jpg, .js, .json, .md, .pdf, .php, .png, .pptx, .py, .rb, .tar, .tex, .ts, .txt, .xlsx, .xml, .zip</i></p>\n</div>\n".formatted(t.getTranslation("component.fileInfoDialog.content", new Object[0]));
    }
}

