/*
 * Decompiled with CFR 0.152.
 */
package fi.evolver.ai.vaadin.component;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import fi.evolver.ai.vaadin.component.i18n.VaadinTranslations;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import org.vaadin.lineawesome.LineAwesomeIcon;

public class StarRatingComponent
extends HorizontalLayout {
    private final List<RatingIconContainer> stars = new ArrayList<RatingIconContainer>();
    private Integer value;
    private Optional<Consumer<Integer>> valueChangeListener = Optional.empty();
    private Boolean enabled;
    private final VaadinTranslations t;

    public StarRatingComponent(Integer value, Integer numStars, Boolean enabled, VaadinTranslations t) {
        this.value = value;
        this.enabled = enabled;
        this.t = t;
        this.initStars(numStars);
        this.setSpacing(false);
        this.add(this.stars.stream().map(s -> s).toList());
        this.getElement().executeJs("const children = this.children\n\nfor (let i = 0; i < children.length; i++) {\n\tchildren[i].addEventListener(\"mouseover\", _ => {\n\t\tfor (let k = 0; k <= i; k++)\n\t\t\tchildren[k].style = 'color: yellow'\n\t})\n\tchildren[i].addEventListener(\"mouseout\", _ => {\n\t\tfor (let k = 0; k <= i; k++)\n\t\t\tchildren[k].style = ''\n\t})\n}\n", new Serializable[0]);
    }

    public StarRatingComponent(Integer value, Integer numStars, VaadinTranslations t) {
        this(value, numStars, true, t);
    }

    public StarRatingComponent(Integer value, VaadinTranslations t) {
        this(value, 5, t);
    }

    public StarRatingComponent(VaadinTranslations t) {
        this(null, t);
    }

    public Integer getValue() {
        return this.value;
    }

    public void setValue(Integer value) {
        this.value = value;
        this.updateStarIcons();
    }

    public void addValueChangeListener(Consumer<Integer> listener) {
        this.valueChangeListener = Optional.of(listener);
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
        this.updateStarIcons();
    }

    private void initStars(Integer numStars) {
        for (int i = 0; i < numStars; ++i) {
            RatingIconContainer star = new RatingIconContainer(i + 1, this.value != null && this.value > i, this::handleStarClicked, this.t);
            this.stars.add(star);
        }
    }

    private void handleStarClicked(Integer starValue) {
        if (this.value != null && this.value == starValue) {
            this.setValue(null);
        } else {
            this.setValue(starValue);
        }
        this.valueChangeListener.ifPresent(l -> l.accept(this.value));
    }

    private void updateStarIcons() {
        for (int i = 0; i < this.stars.size(); ++i) {
            RatingIconContainer star = this.stars.get(i);
            star.setFilled(this.value != null && this.value > i);
            star.setEnabled(this.enabled);
        }
    }

    private static class RatingIconContainer
    extends Div {
        private final int value;
        private boolean isFilled;
        private Component icon;

        public RatingIconContainer(int value, Boolean isFilled, Consumer<Integer> onClick, VaadinTranslations t) {
            this.value = value;
            this.isFilled = isFilled;
            this.icon = this.getIcon();
            this.add(new Component[]{this.icon});
            this.addClassName("flex");
            super.addClickListener((ComponentEventListener & Serializable)e -> onClick.accept(this.value));
            this.setTitle(t.getTranslation("component.starRating.label", new Object[0]));
        }

        public void setFilled(Boolean value) {
            if (this.isFilled == value) {
                return;
            }
            this.isFilled = value;
            this.remove(new Component[]{this.icon});
            this.icon = this.getIcon();
            this.add(new Component[]{this.icon});
        }

        private Component getIcon() {
            return this.isFilled ? LineAwesomeIcon.STAR_SOLID.create() : LineAwesomeIcon.STAR.create();
        }
    }
}

