/*
 * Decompiled with CFR 0.152.
 */
package fi.evolver.ai.vaadin.entity;

import fi.evolver.ai.vaadin.entity.ChatMessage;
import fi.evolver.ai.vaadin.util.AuthUtils;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OrderBy;
import jakarta.persistence.Table;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.hibernate.annotations.Fetch;
import org.hibernate.annotations.FetchMode;

@Entity
@Table(name="chat")
public class Chat {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private long id;
    @Column(name="chat_id")
    private String chatId;
    @Column(name="username")
    private String username;
    @Column(name="display_name")
    private String displayName;
    @Column(name="start_time")
    private LocalDateTime startTime;
    @Column(name="chat_type")
    private String chatType;
    @Column(name="summary")
    private String summary;
    @Column(name="favorite")
    private boolean favorite;
    @Column(name="chat_rating")
    private Integer chatRating;
    @OneToMany(mappedBy="chat", cascade={CascadeType.ALL}, orphanRemoval=true, fetch=FetchType.EAGER)
    @OrderBy(value="id")
    @Fetch(value=FetchMode.SUBSELECT)
    private List<ChatMessage> chatMessages = new ArrayList<ChatMessage>();

    public Chat() {
    }

    public Chat(String chatType) {
        this.chatId = UUID.randomUUID().toString();
        this.username = AuthUtils.getEmail();
        this.displayName = AuthUtils.getUsername();
        this.chatType = chatType;
        this.startTime = LocalDateTime.now();
    }

    public long getId() {
        return this.id;
    }

    public String getChatId() {
        return this.chatId;
    }

    public String getChatType() {
        return this.chatType;
    }

    public void setChatType(String chatType) {
        this.chatType = chatType;
    }

    public LocalDateTime getStartTime() {
        return this.startTime;
    }

    public String getUsername() {
        return this.username;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getSummary() {
        return this.summary;
    }

    public void setSummary(String summary) {
        this.summary = summary != null ? summary.substring(0, Math.min(350, summary.length())) : summary;
    }

    public boolean isFavorite() {
        return this.favorite;
    }

    public void setFavorite(boolean favorite) {
        this.favorite = favorite;
    }

    public Integer getChatRating() {
        return this.chatRating;
    }

    public void setChatRating(Integer rating) {
        this.chatRating = rating;
    }

    public List<ChatMessage> getChatMessages() {
        return Collections.unmodifiableList(this.chatMessages);
    }

    public boolean hasMessages() {
        return !this.chatMessages.isEmpty();
    }

    public void addChatMessages(List<ChatMessage> chatMessages) {
        for (ChatMessage chatMessage : chatMessages) {
            chatMessage.setChat(this);
            this.chatMessages.add(chatMessage);
        }
    }

    public void addChatMessage(ChatMessage chatMessage) {
        this.addChatMessages(Collections.singletonList(chatMessage));
    }

    public String toString() {
        return "Chat [id=" + this.id + ", chatId=" + this.chatId + ", username=" + this.username + ", displayName=" + this.displayName + ", startTime=" + this.startTime + ", chatType=" + this.chatType + ", summary=" + this.summary + ", favorite=" + this.favorite + ", chatMessages=" + this.chatMessages + ", chatRating=" + this.chatRating + "]";
    }
}

