/*
 * Decompiled with CFR 0.152.
 */
package fi.evolver.ai.vaadin.entity;

import fi.evolver.ai.vaadin.entity.Chat;
import fi.evolver.utils.GzipUtils;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Table;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.zip.GZIPInputStream;

@Entity
@Table(name="chat_attachment")
public class ChatAttachment {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private long id;
    @Column(name="mime_type")
    private String mimeType;
    @Column(name="data")
    private byte[] data;
    @Column(name="creation_time")
    private LocalDateTime creationTime;
    @Column(name="provider")
    private String provider;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="chat_id")
    private Chat chat;

    public ChatAttachment() {
    }

    public ChatAttachment(String mimeType, byte[] data, String provider, Chat chat) {
        this.mimeType = mimeType;
        this.data = ChatAttachment.compressData(data);
        this.creationTime = LocalDateTime.now();
        this.provider = provider;
        this.chat = chat;
    }

    public byte[] getData() {
        return ChatAttachment.decompressData(this.data);
    }

    private static byte[] compressData(byte[] data) {
        return GzipUtils.zip((byte[])data);
    }

    private static byte[] decompressData(byte[] data) {
        try {
            int bytesRead;
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(data);
            GZIPInputStream gzipInputStream = new GZIPInputStream(byteArrayInputStream);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            while ((bytesRead = gzipInputStream.read(buffer)) != -1) {
                byteArrayOutputStream.write(buffer, 0, bytesRead);
            }
            gzipInputStream.close();
            byteArrayOutputStream.close();
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException e) {
            e.printStackTrace();
            return new byte[0];
        }
    }

    public String toString() {
        return "ChatAttachment [id=" + this.id + ", chat=" + this.chat.getChatId() + ", mimeType=" + this.mimeType + ", data=" + Arrays.toString(this.getData()) + ", creationTime=" + this.creationTime + ", provider=" + this.provider + "]";
    }
}

