/*
 * Decompiled with CFR 0.152.
 */
package fi.evolver.ai.vaadin.entity;

import com.fasterxml.jackson.annotation.JsonIgnore;
import fi.evolver.ai.spring.Model;
import fi.evolver.ai.spring.util.TokenUtils;
import fi.evolver.ai.vaadin.entity.Chat;
import fi.evolver.ai.vaadin.entity.Prompt;
import fi.evolver.utils.GzipUtils;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Table;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.LocalDateTime;

@Entity
@Table(name="chat_message")
public class ChatMessage {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private long id;
    @Column(name="send_time")
    private LocalDateTime sendTime;
    @Enumerated(value=EnumType.STRING)
    @Column(name="role")
    private ChatMessageRole role;
    @Column(name="message")
    private byte[] message;
    @Column(name="model")
    private String model;
    @Column(name="token_count")
    private Integer tokenCount;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="chat_id")
    private Chat chat;
    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="prompt_id")
    private Prompt prompt;

    public ChatMessage() {
    }

    public ChatMessage(ChatMessageRole role, String message, Prompt prompt, Model<?> model) {
        this.sendTime = LocalDateTime.now();
        this.role = role;
        this.message = ChatMessage.compressData(message);
        this.prompt = prompt;
        this.model = model != null ? model.name() : null;
        this.tokenCount = ChatMessage.calculateTokenCount(role, message, prompt, model);
    }

    public long getId() {
        return this.id;
    }

    public LocalDateTime getSendTime() {
        return this.sendTime;
    }

    public ChatMessageRole getRole() {
        return this.role;
    }

    public String getMessage() {
        return ChatMessage.readCompressed(this.message);
    }

    public String getModel() {
        return this.model;
    }

    public Integer getTokenCount() {
        return this.tokenCount;
    }

    public void setTokenCount(Integer tokenCount) {
        this.tokenCount = tokenCount;
    }

    @JsonIgnore
    public Chat getChat() {
        return this.chat;
    }

    public void setChat(Chat chat) {
        this.chat = chat;
    }

    public Prompt getPrompt() {
        return this.prompt;
    }

    public void setPrompt(Prompt chatPrompt) {
        this.prompt = chatPrompt;
    }

    private static byte[] compressData(String textData) {
        return GzipUtils.zip((String)textData, (Charset)StandardCharsets.UTF_8);
    }

    private static String readCompressed(byte[] data) {
        return GzipUtils.unzip((byte[])data, (Charset)StandardCharsets.UTF_8);
    }

    public String toString() {
        return "ChatMessage [id=" + this.id + ", sendTime=" + this.sendTime + ", role=" + this.role + ", message=" + this.getMessage() + ", model=" + this.model + ", tokenCount=" + this.tokenCount + ", chat=" + this.chat.getId() + ", prompt=" + this.prompt + "]";
    }

    private static Integer calculateTokenCount(ChatMessageRole role, String message, Prompt prompt, Model<?> model) {
        return switch (role) {
            case ChatMessageRole.ASSISTANT -> {
                if (model != null) {
                    yield TokenUtils.calculateTokens((String)message, model);
                }
                yield null;
            }
            case ChatMessageRole.USER -> {
                if (prompt != null) {
                    yield prompt.getTokenCount();
                }
                yield null;
            }
            default -> null;
        };
    }

    public static enum ChatMessageRole {
        SYSTEM,
        USER,
        ASSISTANT,
        ERROR;

    }
}

