/*
 * Decompiled with CFR 0.152.
 */
package fi.evolver.ai.vaadin.entity;

import fi.evolver.utils.GzipUtils;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.Table;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

@Entity
@Table(name="prompt")
public class Prompt {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private long id;
    @Column(name="prompt")
    private byte[] prompt;
    @Column(name="token_count")
    private Integer tokenCount;

    public Prompt() {
    }

    public Prompt(String prompt, Integer tokenCount) {
        if (prompt != null) {
            this.prompt = Prompt.compressData(prompt);
            this.tokenCount = tokenCount;
        }
    }

    public long getId() {
        return this.id;
    }

    public String getPrompt() {
        return Prompt.readCompressed(this.prompt);
    }

    public Integer getTokenCount() {
        return this.tokenCount;
    }

    private static byte[] compressData(String textData) {
        return GzipUtils.zip((String)textData, (Charset)StandardCharsets.UTF_8);
    }

    private static String readCompressed(byte[] data) {
        return GzipUtils.unzip((byte[])data, (Charset)StandardCharsets.UTF_8);
    }

    public String toString() {
        return "Prompt [id=" + this.id + ", prompt=" + this.getPrompt() + ", tokenCount=" + this.tokenCount + "]";
    }
}

