/*
 * Decompiled with CFR 0.152.
 */
package fi.evolver.ai.vaadin.entity;

import fi.evolver.ai.vaadin.entity.UserProfileParameter;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OrderBy;
import jakarta.persistence.Table;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.hibernate.annotations.Fetch;
import org.hibernate.annotations.FetchMode;

@Entity
@Table(name="user_profile")
public class UserProfile {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private long id;
    @Column(name="username")
    private String username;
    @Column(name="language")
    private String language;
    @OneToMany(mappedBy="userProfile", cascade={CascadeType.ALL}, orphanRemoval=true, fetch=FetchType.EAGER)
    @OrderBy(value="id")
    @Fetch(value=FetchMode.SUBSELECT)
    private List<UserProfileParameter> parameters;

    public UserProfile() {
    }

    public UserProfile(String username) {
        this.username = username;
        this.parameters = new ArrayList<UserProfileParameter>();
    }

    public long getId() {
        return this.id;
    }

    public String getUsername() {
        return this.username;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    private Optional<UserProfileParameter> getUserProfileParameter(String key) {
        return this.parameters.stream().filter(param -> param.getKey().equals(key)).findFirst();
    }

    public Optional<String> getParameter(String key) {
        return this.getUserProfileParameter(key).map(UserProfileParameter::getValue);
    }

    public void setParameter(String key, String value) {
        this.getUserProfileParameter(key).ifPresentOrElse(p -> p.setValue(value), () -> this.parameters.add(new UserProfileParameter(this, key, value)));
    }

    public String toString() {
        return "UserProfile [id=" + this.id + ", username=" + this.username + ", language=" + this.language + ", userProfileParameters=" + this.parameters + "]";
    }
}

