/*
 * Decompiled with CFR 0.152.
 */
package fi.evolver.ai.vaadin.translations;

import com.vaadin.flow.i18n.I18NProvider;
import fi.evolver.ai.vaadin.translations.TranslationProvider;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CompositeI18nProvider
implements I18NProvider {
    private static final Logger LOG = LoggerFactory.getLogger(CompositeI18nProvider.class);
    final Set<Locale> providedLocales;
    private final List<TranslationProvider> providers;
    private static final int MAX_CACHE_ENTRIES = 512;
    private static final Map<String, TranslationProvider> providerCache = Collections.synchronizedMap(new LinkedHashMap<String, TranslationProvider>(512, 0.75f, true){

        @Override
        public boolean removeEldestEntry(Map.Entry<String, TranslationProvider> eldest) {
            return this.size() >= 512;
        }
    });

    @Autowired
    public CompositeI18nProvider(List<TranslationProvider> providers) {
        this.providers = providers;
        this.providedLocales = this.providers.stream().flatMap(p -> p.getProvidedLocales().stream()).collect(Collectors.toSet());
        LOG.debug("Initializing i18n with providers: {}", (Object)String.join((CharSequence)", ", providers.stream().map(l -> l.getClass().toString()).toList()));
    }

    public List<Locale> getProvidedLocales() {
        return this.providedLocales.stream().toList();
    }

    public String getTranslation(String key, Locale locale, Object ... params) {
        String value = this.getTranslationFromProviders(key, locale, params);
        if (params != null && params.length > 0) {
            return new MessageFormat(value, locale).format(params);
        }
        return value;
    }

    public String getTranslationFromProviders(String key, Locale locale, Object ... params) {
        String cacheKey = locale.toString() + ";" + key;
        TranslationProvider cachedProvider = providerCache.get(cacheKey);
        if (cachedProvider != null && cachedProvider.hasTranslation(key, locale)) {
            return cachedProvider.getTranslation(key, locale);
        }
        LOG.trace("Getting translation for key \"{}\" and locale: {}", (Object)key, (Object)locale.toString());
        for (TranslationProvider provider : this.providers) {
            if (!CompositeI18nProvider.providesLocale(provider, locale)) {
                LOG.trace("\tSkipping {} because it doesn't provide the requested locale", provider.getClass());
                continue;
            }
            if (provider.hasTranslation(key, locale)) {
                providerCache.put(cacheKey, provider);
                return provider.getTranslation(key, locale);
            }
            LOG.trace("\tSkipping {} because it doesn't have the translation key", provider.getClass());
        }
        return key;
    }

    private static boolean providesLocale(TranslationProvider provider, Locale locale) {
        return provider.getProvidedLocales().contains(locale) || provider.getProvidedLocales().contains(Locale.ROOT) || provider.getProvidedLocales().stream().anyMatch(l -> l.getLanguage().equals(locale.getLanguage()));
    }
}

