/*
 * Decompiled with CFR 0.152.
 */
package fi.evolver.ai.vaadin.translations;

import fi.evolver.ai.vaadin.translations.TranslationProvider;
import java.util.HashSet;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

public abstract class ResourceBundleTranslationProvider
implements TranslationProvider {
    protected static final Logger LOG = LoggerFactory.getLogger(ResourceBundleTranslationProvider.class);
    private final String bundleBaseName;
    private final Set<Locale> providedLocales;

    public ResourceBundleTranslationProvider(String translationsFolder, String translationsBaseName) {
        this.bundleBaseName = translationsFolder + "." + translationsBaseName;
        this.providedLocales = ResourceBundleTranslationProvider.loadProvidedLocales(translationsFolder, translationsBaseName);
        LOG.debug("Providing locales: {}", (Object)String.join((CharSequence)", ", this.providedLocales.stream().map(l -> l.equals(Locale.ROOT) ? "default" : l.toString()).toList()));
    }

    @Override
    public Set<Locale> getProvidedLocales() {
        return this.providedLocales;
    }

    @Override
    public boolean hasTranslation(String key, Locale locale) {
        ResourceBundle bundle = this.getBundle(locale);
        if (bundle == null) {
            return false;
        }
        return bundle.containsKey(key);
    }

    @Override
    public String getTranslation(String key, Locale locale) {
        String value;
        ResourceBundle bundle = this.getBundle(locale);
        if (bundle == null) {
            return key;
        }
        try {
            value = bundle.getString(key);
        }
        catch (MissingResourceException e) {
            LOG.debug("Missing resource for key " + key, (Throwable)e);
            return "!" + locale.getLanguage() + ": " + key;
        }
        return value;
    }

    private ResourceBundle getBundle(Locale locale) {
        try {
            return ResourceBundle.getBundle(this.bundleBaseName, locale, this.getClass().getClassLoader());
        }
        catch (MissingResourceException e) {
            LOG.warn("Missing translations for locale " + locale.getDisplayName(), (Throwable)e);
            return null;
        }
    }

    private static Set<Locale> loadProvidedLocales(String resourceFolder, String translationsBaseName) {
        Pattern translationFileLocalePattern = Pattern.compile(translationsBaseName + "_?(\\w*)\\.properties");
        HashSet<Locale> providedLocales = new HashSet<Locale>();
        try {
            Resource[] translations;
            PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
            for (Resource res : translations = resolver.getResources("classpath:/" + resourceFolder + "/" + translationsBaseName + "*")) {
                Matcher m = translationFileLocalePattern.matcher(res.getFilename());
                if (!m.find()) continue;
                Locale l = Locale.forLanguageTag(m.group(1).replace('_', '-'));
                providedLocales.add(l);
            }
        }
        catch (Exception e) {
            LOG.error("Error loading provided locales: {}", (Object)e.getMessage());
        }
        return providedLocales;
    }
}

