/*
 * Decompiled with CFR 0.152.
 */
package fi.evolver.ai.vaadin.translations;

import com.vaadin.flow.server.UIInitEvent;
import com.vaadin.flow.server.UIInitListener;
import com.vaadin.flow.server.VaadinService;
import fi.evolver.ai.vaadin.UserProfileRepository;
import fi.evolver.ai.vaadin.entity.UserProfile;
import fi.evolver.utils.string.StringUtils;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class SessionLocaleConfigurator
implements UIInitListener {
    private static final Logger LOG = LoggerFactory.getLogger(SessionLocaleConfigurator.class);
    @Value(value="${vaadin.default-language:AUTO}")
    private String defaultLanguageCode;
    @Autowired
    private UserProfileRepository userProfileRepository;

    public void uiInit(UIInitEvent event) {
        LOG.trace("Initializing UI");
        String langCode = this.defaultLanguageCode;
        UserProfile user = this.userProfileRepository.findOrCreateUserProfile();
        if (user != null && StringUtils.hasText((String)user.getLanguage())) {
            langCode = user.getLanguage();
        }
        Locale locale = null;
        if ("AUTO".equals(langCode)) {
            LOG.trace("Trying to get requested locale");
            try {
                locale = VaadinService.getCurrentRequest().getLocale();
                LOG.trace("Got {} from request", (Object)locale.toString());
            }
            catch (Exception e) {
                locale = null;
            }
            if (locale == null) {
                LOG.trace("Trying to get browser locale");
                try {
                    locale = event.getUI().getSession().getBrowser().getLocale();
                    LOG.trace("Got {} from browser", (Object)locale.toString());
                }
                catch (Exception e) {
                    locale = null;
                }
            }
        } else {
            try {
                locale = Locale.forLanguageTag(langCode);
            }
            catch (Exception e) {
                locale = null;
            }
        }
        if (locale == null) {
            LOG.trace("Defaulting to english");
            locale = Locale.ENGLISH;
        }
        LOG.debug("Setting UI locale to {}", (Object)locale.toString());
        event.getUI().setLocale(locale);
    }
}

