/*
 * Decompiled with CFR 0.152.
 */
package fi.evolver.ai.vaadin.util;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.oauth2.core.OAuth2AuthenticatedPrincipal;

public class AuthUtils {
    private static Set<String> adminUsers = new HashSet<String>();
    private static Set<String> domains = new HashSet<String>();

    private AuthUtils() {
    }

    public static String getUsername() {
        return AuthUtils.getAttribute("given_name");
    }

    public static String getEmail() {
        return AuthUtils.getAttribute("email");
    }

    private static String getAttribute(String attribute) {
        OAuth2AuthenticatedPrincipal principal = AuthUtils.getPrincipal();
        return principal != null ? (String)principal.getAttribute(attribute) : null;
    }

    public static boolean isAdminUser() {
        String email = AuthUtils.getEmail();
        return email != null && (domains.contains(email.substring(email.indexOf(64) + 1)) || adminUsers.contains(email));
    }

    public static void setAdminUsers(List<String> adminUserList) {
        if (adminUserList != null && !adminUserList.isEmpty() && adminUsers.isEmpty()) {
            adminUsers = new HashSet<String>(adminUserList);
        }
    }

    public static void setAdminDomains(List<String> domainsList) {
        if (domainsList != null && !domainsList.isEmpty() && domains.isEmpty()) {
            domains = new HashSet<String>(domainsList);
        }
    }

    private static OAuth2AuthenticatedPrincipal getPrincipal() {
        Object principal = SecurityContextHolder.getContext().getAuthentication().getPrincipal();
        if (!(principal instanceof OAuth2AuthenticatedPrincipal)) {
            return null;
        }
        return (OAuth2AuthenticatedPrincipal)principal;
    }
}

