/*
 * Decompiled with CFR 0.152.
 */
package fi.evolver.ai.vaadin.util;

import com.vladsch.flexmark.html.HtmlRenderer;
import com.vladsch.flexmark.parser.Parser;
import com.vladsch.flexmark.util.ast.Document;
import com.vladsch.flexmark.util.ast.Node;
import fi.evolver.ai.spring.Model;
import fi.evolver.ai.spring.chat.ChatApi;
import fi.evolver.ai.spring.chat.prompt.ChatPrompt;
import fi.evolver.ai.spring.chat.prompt.Message;
import fi.evolver.ai.vaadin.entity.Chat;
import fi.evolver.ai.vaadin.entity.ChatMessage;
import fi.evolver.utils.DateUtils;
import fi.evolver.utils.NullSafetyUtils;
import java.time.Instant;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.Optional;

public class ChatUtils {
    private static final Parser PARSER = Parser.builder().build();
    private static final HtmlRenderer RENDERER = HtmlRenderer.builder().build();

    private ChatUtils() {
    }

    public static Instant convertToInstantFi(LocalDateTime ldt) {
        return ldt.atZone(DateUtils.ZONE_HELSINKI).toInstant();
    }

    public static Instant currentTimeHelsinki() {
        return ChatUtils.convertToInstantFi(LocalDateTime.now());
    }

    public static String convertToHtml(String original) {
        Document document = PARSER.parse(original);
        String html = "<div style=\"white-space: pre-wrap; line-height: 20px; margin-top: 2px;\">%s</div>".formatted(RENDERER.render((Node)document));
        return html.replaceAll("href=", "router-ignore=\"true\" href=").replaceAll("<p>", "<p style=\"margin: 0\">").replaceAll("<pre>", "<pre style=\"margin: 0\">");
    }

    public static String inferUsername(Chat chat, ChatMessage message) {
        return switch (message.getRole()) {
            case ChatMessage.ChatMessageRole.ASSISTANT -> "AI";
            case ChatMessage.ChatMessageRole.USER -> (String)NullSafetyUtils.denull((Object[])new String[]{chat.getDisplayName(), "User"});
            default -> "Unknown";
        };
    }

    public static Optional<CommandType> parseCommand(String text) {
        return text.startsWith("/") ? Arrays.asList(CommandType.values()).stream().filter(c -> c.name().equalsIgnoreCase(text.substring(1))).findFirst() : Optional.empty();
    }

    public static ChatPrompt createSummaryPrompt(Model<ChatApi> model, Optional<String> provider, String userMessage, String assistantMessage) {
        ChatPrompt.Builder builder = ChatPrompt.builder(model).add(Message.system((String)"Summarize the following conversation in less than 15 words. Ensure carefully that you understand the language of the question words the user is writing! This is the main language in which you MUST write the summary.")).add(Message.user((String)userMessage)).add(Message.assistant((String)assistantMessage));
        provider.ifPresent(p -> builder.setParameter("provider", p));
        return builder.build();
    }

    public static enum CommandType {
        DEBUG,
        DEBUG_FULL,
        LOAD;

    }
}

