/*
 * Decompiled with CFR 0.152.
 */
package fi.evolver.ai.vaadin.view;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.button.ButtonVariant;
import com.vaadin.flow.component.datepicker.DatePicker;
import com.vaadin.flow.component.html.H2;
import com.vaadin.flow.component.notification.Notification;
import com.vaadin.flow.component.orderedlayout.FlexComponent;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.component.shared.ThemeVariant;
import com.vaadin.flow.router.BeforeEnterEvent;
import com.vaadin.flow.router.BeforeEnterObserver;
import com.vaadin.flow.server.Command;
import com.vaadin.flow.server.StreamResource;
import com.vaadin.flow.server.StreamResourceWriter;
import fi.evolver.ai.vaadin.ChatRepository;
import fi.evolver.ai.vaadin.admin.ChatExportGenerator;
import fi.evolver.ai.vaadin.admin.ChatReportGenerator;
import fi.evolver.ai.vaadin.component.ComponentSource;
import fi.evolver.ai.vaadin.entity.Chat;
import fi.evolver.ai.vaadin.util.AuthUtils;
import fi.evolver.ai.vaadin.view.AdminView;
import jakarta.annotation.PostConstruct;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.temporal.TemporalAdjusters;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.vaadin.olli.FileDownloadWrapper;

public class AdminBaseView
extends VerticalLayout
implements BeforeEnterObserver {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(AdminBaseView.class);
    private final VerticalLayout layout = new VerticalLayout();
    private final Locale localeFi = new Locale("fi", "FI");
    private final Button fetchChatsButton;
    private final Button fetchChatsFullButton;
    private final Button generateReportButton;
    private final DatePicker startDatePicker;
    private final DatePicker endDatePicker;
    private final ChatRepository chatRepository;
    @Autowired(required=false)
    private List<ComponentSource<AdminView>> additionalComponents = new ArrayList<ComponentSource<AdminView>>();

    public AdminBaseView(ChatRepository chatRepository) {
        this.chatRepository = chatRepository;
        this.fetchChatsButton = new Button(this.getTranslation("view.admin.fetchChats", new Object[0]));
        this.fetchChatsFullButton = new Button(this.getTranslation("view.admin.fetchFullChats", new Object[0]));
        this.generateReportButton = new Button(this.getTranslation("view.admin.generateReport", new Object[0]));
        this.startDatePicker = new DatePicker(this.getTranslation("view.admin.starDate", new Object[0]));
        this.endDatePicker = new DatePicker(this.getTranslation("view.admin.endDate", new Object[0]));
    }

    @PostConstruct
    private void createUi() {
        this.layout.add(new Component[]{new H2(this.getTranslation("view.admin.headline", new Object[0])), this.startDatePicker, this.endDatePicker, this.createFileDownloadWrapper(ExportType.ONLY_MESSAGES), this.createFileDownloadWrapper(ExportType.FULL), this.createFileDownloadWrapper(ExportType.REPORT)});
        this.additionalComponents.stream().sorted().map(ComponentSource::getComponent).forEach(xva$0 -> this.layout.add(new Component[]{xva$0}));
        this.layout.setAlignItems(FlexComponent.Alignment.START);
        this.layout.setSpacing(true);
        this.layout.setMargin(true);
        this.add(new Component[]{this.layout});
        this.startDatePicker.setLocale(this.localeFi);
        this.endDatePicker.setLocale(this.localeFi);
        this.startDatePicker.setMin(LocalDate.now().minusYears(1L));
        this.endDatePicker.setMax(LocalDate.now());
        this.startDatePicker.setValue(AdminBaseView.getInitialStartDate());
        this.endDatePicker.setValue(AdminBaseView.getInitialEndDate());
        this.fetchChatsButton.addThemeVariants((ThemeVariant[])new ButtonVariant[]{ButtonVariant.LUMO_PRIMARY});
        this.fetchChatsFullButton.addThemeVariants((ThemeVariant[])new ButtonVariant[]{ButtonVariant.LUMO_PRIMARY});
        this.generateReportButton.addThemeVariants((ThemeVariant[])new ButtonVariant[]{ButtonVariant.LUMO_PRIMARY});
    }

    public void beforeEnter(BeforeEnterEvent event) {
        if (!AuthUtils.isAdminUser()) {
            event.forwardTo("/");
        }
    }

    private FileDownloadWrapper createFileDownloadWrapper(ExportType type) {
        FileDownloadWrapper wrapper = new FileDownloadWrapper(this.createStreamResource(type));
        wrapper.wrapComponent((Component)this.getButton(type));
        return wrapper;
    }

    private StreamResource createStreamResource(final ExportType type) {
        return new StreamResource(this.generateFilename(type), (StreamResourceWriter & Serializable)(o, s) -> this.generateContent(o, type)){
            private static final long serialVersionUID = 1L;

            public Map<String, String> getHeaders() {
                HashMap<String, String> headers = new HashMap<String, String>(super.getHeaders());
                headers.put("Content-Disposition", "attachment; filename=\"" + AdminBaseView.this.generateFilename(type) + "\"");
                return headers;
            }
        };
    }

    private Button getButton(ExportType type) {
        return switch (type) {
            case ExportType.FULL -> this.fetchChatsFullButton;
            case ExportType.ONLY_MESSAGES -> this.fetchChatsButton;
            case ExportType.REPORT -> this.generateReportButton;
            default -> throw new IllegalArgumentException("Unexpected value: " + type);
        };
    }

    private String generateFilename(ExportType type) {
        String dateRangePart = "%s-%s".formatted(this.startDatePicker.getValue() != null ? this.startDatePicker.getValue() : AdminBaseView.getInitialStartDate(), this.endDatePicker.getValue() != null ? this.endDatePicker.getValue() : AdminBaseView.getInitialEndDate());
        return switch (type) {
            case ExportType.FULL -> "chats-full_%s.md".formatted(dateRangePart);
            case ExportType.ONLY_MESSAGES -> "chats_%s.md".formatted(dateRangePart);
            case ExportType.REPORT -> "chat-report_%s.xlsx".formatted(dateRangePart);
            default -> throw new IllegalArgumentException("Unexpected value: " + type);
        };
    }

    private void generateContent(OutputStream out, ExportType type) {
        try {
            LocalDateTime endTime;
            if (!AuthUtils.isAdminUser()) {
                this.showNotification(this.getTranslation("view.admin.forbiddenOperation", new Object[0]));
                return;
            }
            LocalDate startDate = (LocalDate)this.startDatePicker.getValue();
            LocalDate endDate = (LocalDate)this.endDatePicker.getValue();
            LocalDateTime startTime = AdminBaseView.parseStartTime(startDate);
            if (!AdminBaseView.isValidReportRange(startTime, endTime = AdminBaseView.parseEndTime(endDate))) {
                this.showNotification(this.getTranslation("view.admin.invalidDateRange", new Object[]{startDate, endDate}));
                return;
            }
            List<Chat> chats = this.chatRepository.findAllByStartTimeGreaterThanEqualAndStartTimeLessThanEqualOrderByIdDesc(startTime, endTime);
            if (type == ExportType.REPORT) {
                ChatReportGenerator.generateChatReport(chats, startDate, endDate, out);
            } else {
                out.write(ChatExportGenerator.generateChatExport(chats, startDate, endDate, type, (arg_0, arg_1) -> ((AdminBaseView)this).getTranslation(arg_0, arg_1)).getBytes());
            }
        }
        catch (IOException e) {
            LOG.error("Failed generating file content", (Throwable)e);
            this.showNotification(this.getTranslation("view.admin.errorGenerating", new Object[0]));
        }
    }

    private static LocalDateTime parseEndTime(LocalDate endDate) {
        return endDate != null ? endDate.atTime(LocalTime.MAX) : null;
    }

    private static LocalDateTime parseStartTime(LocalDate startDate) {
        return startDate != null ? startDate.atStartOfDay() : null;
    }

    private static LocalDate getInitialStartDate() {
        return LocalDate.now().with(TemporalAdjusters.firstDayOfMonth());
    }

    private static LocalDate getInitialEndDate() {
        return LocalDate.now();
    }

    private static boolean isValidReportRange(LocalDateTime startTime, LocalDateTime endTime) {
        return startTime != null && endTime != null && startTime.isBefore(endTime);
    }

    private void showNotification(String message) {
        this.getUI().ifPresent(ui -> ui.access((Command & Serializable)() -> Notification.show((String)message, (int)6000, (Notification.Position)Notification.Position.MIDDLE)));
    }

    public static enum ExportType {
        ONLY_MESSAGES,
        FULL,
        REPORT;

    }
}

