/*
 * Decompiled with CFR 0.152.
 */
package fi.evolver.ai.vaadin.view;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.applayout.AppLayout;
import com.vaadin.flow.component.applayout.DrawerToggle;
import com.vaadin.flow.component.html.H2;
import com.vaadin.flow.component.html.Header;
import com.vaadin.flow.component.html.Image;
import com.vaadin.flow.component.orderedlayout.Scroller;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.component.sidenav.SideNav;
import com.vaadin.flow.component.sidenav.SideNavItem;
import com.vaadin.flow.router.HasDynamicTitle;
import com.vaadin.flow.router.PageTitle;
import fi.evolver.ai.vaadin.translations.PageTitleTranslationKey;
import fi.evolver.ai.vaadin.util.AuthUtils;
import fi.evolver.utils.string.StringUtils;
import java.util.List;
import org.vaadin.lineawesome.LineAwesomeIcon;

public abstract class BaseLayout
extends AppLayout
implements HasDynamicTitle {
    private static final long serialVersionUID = 1L;
    protected H2 viewTitle = new H2();

    public BaseLayout() {
        this.viewTitle.addClassNames(new String[]{"text-l", "m-0"});
        this.viewTitle.setMaxWidth("50%");
        this.setPrimarySection(AppLayout.Section.DRAWER);
        this.addDrawerContent();
        this.addHeaderContent();
    }

    public abstract Image createHeaderImage();

    public List<SideNavItem> createNavRoutes() {
        return List.of();
    }

    public List<SideNav> createNavSections() {
        return List.of();
    }

    public boolean generateDefaultProfileRoute() {
        return true;
    }

    public boolean generateDefaultAdminRoute() {
        return true;
    }

    private void addDrawerContent() {
        this.addToDrawer(new Component[]{new Header(new Component[]{this.createHeaderImage()}), new Scroller((Component)this.createNavigation())});
    }

    private VerticalLayout createNavigation() {
        VerticalLayout layout = new VerticalLayout();
        layout.setSpacing(true);
        layout.setSizeUndefined();
        this.createNavSections().forEach(nav -> {
            nav.setWidthFull();
            layout.add(new Component[]{nav});
        });
        if (!this.createNavRoutes().isEmpty() || this.generateDefaultProfileRoute()) {
            SideNav sideNav = new SideNav();
            sideNav.setWidthFull();
            this.createNavRoutes().forEach(xva$0 -> sideNav.addItem(new SideNavItem[]{xva$0}));
            if (this.generateDefaultProfileRoute()) {
                sideNav.addItem(new SideNavItem[]{new SideNavItem(this.getTranslation("nav.profile", new Object[0]), "profile", LineAwesomeIcon.USER.create())});
            }
            layout.add(new Component[]{sideNav});
        }
        if (AuthUtils.isAdminUser() && this.generateDefaultAdminRoute()) {
            SideNav adminNav = new SideNav("Admin");
            adminNav.setCollapsible(true);
            adminNav.setExpanded(true);
            adminNav.addItem(new SideNavItem[]{new SideNavItem(this.getTranslation("nav.admin", new Object[0]), "admin", LineAwesomeIcon.USER_SHIELD_SOLID.create())});
            adminNav.setWidthFull();
            layout.add(new Component[]{adminNav});
        }
        return layout;
    }

    private void addHeaderContent() {
        DrawerToggle toggle = new DrawerToggle();
        toggle.getElement().setAttribute("aria-label", this.getTranslation("view.baseLayout.menuToggle", new Object[0]));
        this.addToNavbar(true, new Component[]{toggle, this.viewTitle});
    }

    protected void afterNavigation() {
        super.afterNavigation();
        this.viewTitle.setText(this.getCurrentPageTitle());
    }

    public void updateTitle(String title) {
        this.viewTitle.setText(title);
    }

    public String getPageTitle() {
        return this.getCurrentPageTitle();
    }

    private String getCurrentPageTitle() {
        Component component = this.getContent();
        if (component instanceof HasDynamicTitle) {
            return ((HasDynamicTitle)component).getPageTitle();
        }
        PageTitleTranslationKey translationKey = component.getClass().getAnnotation(PageTitleTranslationKey.class);
        if (translationKey != null && StringUtils.hasText((String)translationKey.value())) {
            return this.getTranslation(translationKey.value(), new Object[0]);
        }
        PageTitle title = component.getClass().getAnnotation(PageTitle.class);
        if (title != null && StringUtils.hasText((String)title.value())) {
            return title.value();
        }
        return this.getTranslation("viewTitle.%s".formatted(component.getClass().getSimpleName()), new Object[0]);
    }
}

