/*
 * Decompiled with CFR 0.152.
 */
package fi.evolver.ai.vaadin.view;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.router.BeforeEnterEvent;
import com.vaadin.flow.router.BeforeEnterObserver;
import com.vaadin.flow.router.BeforeEvent;
import com.vaadin.flow.router.Location;
import com.vaadin.flow.router.QueryParameters;
import fi.evolver.ai.vaadin.view.HistoryAwareChat;
import jakarta.annotation.PostConstruct;
import java.util.List;
import java.util.Optional;

public abstract class ChatHistoryAwareView
extends VerticalLayout
implements BeforeEnterObserver {
    private static final long serialVersionUID = 1L;

    @PostConstruct
    public void init() {
        this.addClassName("overflow-hidden");
        if (this.isFullSize()) {
            this.setSizeFull();
        }
        this.getPreChatComponent().ifPresent(xva$0 -> this.add(new Component[]{xva$0}));
        this.add(new Component[]{(Component)this.getChatComponent()});
    }

    public void beforeEnter(BeforeEnterEvent event) {
        this.startChatIfExists((BeforeEvent)event);
    }

    public void startChatIfExists(BeforeEvent event) {
        Location location = event.getLocation();
        QueryParameters queryParameters = location.getQueryParameters();
        List chatIdParams = (List)queryParameters.getParameters().get("chatId");
        if (chatIdParams != null && !chatIdParams.isEmpty()) {
            this.getChatComponent().startChatWithHistory((String)chatIdParams.get(0));
        }
    }

    public Optional<Component> getPreChatComponent() {
        return Optional.empty();
    }

    public abstract HistoryAwareChat<? extends Component> getChatComponent();

    public boolean isFullSize() {
        return true;
    }
}

