/*
 * Decompiled with CFR 0.152.
 */
package fi.evolver.ai.vaadin.view;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.button.ButtonVariant;
import com.vaadin.flow.component.dialog.Dialog;
import com.vaadin.flow.component.html.H3;
import com.vaadin.flow.component.html.Hr;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.notification.Notification;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.component.shared.ThemeVariant;
import com.vaadin.flow.component.textfield.TextArea;
import fi.evolver.ai.vaadin.ChatHistoryConfiguration;
import fi.evolver.ai.vaadin.ChatHistoryConfigurationProps;
import fi.evolver.ai.vaadin.ChatRepository;
import fi.evolver.ai.vaadin.component.ChatHistoryAvatarItem;
import fi.evolver.ai.vaadin.entity.Chat;
import fi.evolver.ai.vaadin.util.AuthUtils;
import fi.evolver.ai.vaadin.view.ChatHistoryAction;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public abstract class ChatHistoryBaseView
extends VerticalLayout
implements ChatHistoryAction {
    private static final long serialVersionUID = 1L;
    private static final int DEFAULT_DAYS_TO_SHOW = 30;
    private final ChatRepository chatRepository;
    private final ChatHistoryConfigurationProps chatHistoryConfigurationProps;

    public ChatHistoryBaseView(ChatRepository chatRepository, ChatHistoryConfigurationProps chatHistoryConfigurationProps) {
        this.chatRepository = chatRepository;
        this.chatHistoryConfigurationProps = chatHistoryConfigurationProps;
        this.createContent(false);
    }

    public void createContent(boolean isRefresh) {
        if (isRefresh) {
            this.removeAll();
        }
        this.setWidth("100%");
        this.getStyle().set("flex-grow", "1");
        this.generateHistoryContent();
    }

    private void generateHistoryContent() {
        List<ChatHistoryConfiguration> configs = this.chatHistoryConfigurationProps.getConfigurations();
        if (configs == null || configs.isEmpty()) {
            this.generateNoChatsMessage(this.getTranslation("view.chatHistory.noHistory", new Object[0]));
            return;
        }
        this.generateFavoriteChatsContent();
        this.generateChatHistoryContent();
    }

    private void generateFavoriteChatsContent() {
        this.add(new Component[]{new H3(this.getTranslation("view.chatHistory.favorites", new Object[0]))});
        List<Chat> chats = this.chatRepository.findFavoriteChats(AuthUtils.getEmail());
        Map<String, ChatHistoryConfiguration> configsByType = this.chatHistoryConfigurationProps.getConfigurations().stream().collect(Collectors.toMap(ChatHistoryConfiguration::type, c -> c));
        if (chats.isEmpty()) {
            this.generateNoChatsMessage(this.getTranslation("view.chatHistory.noFavorites", new Object[0]));
        } else {
            chats.stream().filter(c -> c.getSummary() != null && !c.getSummary().isEmpty()).filter(c -> configsByType.get(c.getChatType()) != null).map(c -> new ChatHistoryAvatarItem((Chat)c, (ChatHistoryConfiguration)configsByType.get(c.getChatType()), this)).forEach(xva$0 -> this.add(new Component[]{xva$0}));
        }
        this.add(new Component[]{new Hr()});
    }

    private void generateChatHistoryContent() {
        for (ChatHistoryConfiguration config : this.chatHistoryConfigurationProps.getConfigurations()) {
            this.add(new Component[]{new H3("%s".formatted(config.title()))});
            List<Chat> chats = this.chatRepository.findNonFavoriteChats(AuthUtils.getEmail(), config.type(), LocalDate.now().minusDays(Optional.ofNullable(config.daysToShow()).orElse(30).intValue()).atStartOfDay());
            if (chats.isEmpty()) {
                this.generateNoChatsMessage(this.getTranslation("view.chatHistory.noHistory", new Object[0]));
            } else {
                chats.stream().filter(c -> c.getSummary() != null && !c.getSummary().isEmpty()).map(c -> new ChatHistoryAvatarItem((Chat)c, config, this)).forEach(xva$0 -> this.add(new Component[]{xva$0}));
            }
            this.add(new Component[]{new Hr()});
        }
    }

    @Override
    public void showEditDialog(Chat chat) {
        Dialog editChatDialog = new Dialog();
        editChatDialog.setWidth("400px");
        editChatDialog.setHeaderTitle(this.getTranslation("view.chatHistory.renameChat", new Object[0]));
        VerticalLayout contentLayout = new VerticalLayout();
        contentLayout.setWidthFull();
        contentLayout.setPadding(false);
        contentLayout.setMargin(false);
        TextArea updatedChatSummary = new TextArea(this.getTranslation("view.chatHistory.newName", new Object[0]));
        updatedChatSummary.setWidthFull();
        contentLayout.add(new Component[]{updatedChatSummary});
        editChatDialog.add(new Component[]{contentLayout});
        Button submitButton = new Button(this.getTranslation("common.save", new Object[0]), (ComponentEventListener & Serializable)e -> {
            String updatableValue = updatedChatSummary.getValue().trim();
            if (!updatableValue.isEmpty()) {
                this.renameChat(chat, updatableValue);
                editChatDialog.close();
            }
        });
        submitButton.addThemeVariants((ThemeVariant[])new ButtonVariant[]{ButtonVariant.LUMO_PRIMARY});
        submitButton.getStyle().set("margin-right", "auto");
        editChatDialog.getFooter().add(new Component[]{submitButton});
        Button cancelButton = new Button(this.getTranslation("common.cancel", new Object[0]), (ComponentEventListener & Serializable)e -> editChatDialog.close());
        cancelButton.addThemeVariants((ThemeVariant[])new ButtonVariant[]{ButtonVariant.LUMO_TERTIARY});
        editChatDialog.getFooter().add(new Component[]{cancelButton});
        editChatDialog.open();
    }

    @Override
    public void showRemovalDialog(Chat chat) {
        Dialog removalDialog = new Dialog();
        removalDialog.setHeaderTitle(this.getTranslation("view.chatHistory.confirmDelete.title", new Object[0]));
        removalDialog.add(this.getTranslation("view.chatHistory.confirmDelete.dialog", new Object[0]));
        Button deleteButton = new Button(this.getTranslation("common.delete", new Object[0]), (ComponentEventListener & Serializable)e -> {
            this.removeChat(chat);
            removalDialog.close();
        });
        deleteButton.addThemeVariants((ThemeVariant[])new ButtonVariant[]{ButtonVariant.LUMO_PRIMARY, ButtonVariant.LUMO_ERROR});
        deleteButton.getStyle().set("margin-right", "auto");
        removalDialog.getFooter().add(new Component[]{deleteButton});
        Button cancelButton = new Button(this.getTranslation("common.delete", new Object[0]), (ComponentEventListener & Serializable)e -> removalDialog.close());
        cancelButton.addThemeVariants((ThemeVariant[])new ButtonVariant[]{ButtonVariant.LUMO_TERTIARY});
        removalDialog.getFooter().add(new Component[]{cancelButton});
        removalDialog.open();
    }

    @Override
    public void toggleFavorite(Chat chat) {
        chat.setFavorite(!chat.isFavorite());
        this.chatRepository.save(chat);
        this.createContent(true);
        ChatHistoryBaseView.showNotification(!chat.isFavorite() ? this.getTranslation("view.chatHistory.removedFromFavorites", new Object[0]) : this.getTranslation("view.chatHistory.addedToFavorites", new Object[0]));
    }

    @Override
    public void setChatRating(Chat chat, Integer rating) {
        chat.setChatRating(rating);
        this.chatRepository.save(chat);
    }

    private static void showNotification(String message) {
        Notification.show((String)message, (int)3000, (Notification.Position)Notification.Position.MIDDLE);
    }

    private void renameChat(Chat chat, String updatedSummary) {
        chat.setSummary(updatedSummary);
        this.chatRepository.save(chat);
        this.createContent(true);
    }

    private void removeChat(Chat chat) {
        this.chatRepository.delete(chat);
        this.createContent(true);
    }

    private void generateNoChatsMessage(String message) {
        Span noChatHistory = new Span(message);
        noChatHistory.addClassNames(new String[]{"text-l", "text-primary"});
        this.add(new Component[]{noChatHistory});
    }
}

