/*
 * Decompiled with CFR 0.152.
 */
package fi.evolver.ai.vaadin.view;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.ItemLabelGenerator;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.dependency.Uses;
import com.vaadin.flow.component.html.Hr;
import com.vaadin.flow.component.icon.Icon;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.orderedlayout.FlexComponent;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.component.select.Select;
import com.vaadin.flow.i18n.I18NProvider;
import com.vaadin.flow.server.VaadinServletRequest;
import fi.evolver.ai.vaadin.UserProfileRepository;
import fi.evolver.ai.vaadin.component.ComponentSource;
import fi.evolver.ai.vaadin.entity.UserProfile;
import fi.evolver.ai.vaadin.translations.PageTitleTranslationKey;
import fi.evolver.utils.string.StringUtils;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.security.PermitAll;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.web.authentication.logout.SecurityContextLogoutHandler;

@Uses.Container(value={@Uses(value=Icon.class), @Uses(value=Select.class)})
@PermitAll
@PageTitleTranslationKey(value="nav.profile")
public class ProfileView
extends VerticalLayout {
    private static final long serialVersionUID = 1L;
    @Autowired(required=false)
    private List<ComponentSource<ProfileView>> additionalComponents = new ArrayList<ComponentSource<ProfileView>>();
    private final UserProfileRepository userProfileRepository;
    private final I18NProvider I18nProvider;
    private final Select<Locale> languageSelect = new Select();
    private final HorizontalLayout endSection = new HorizontalLayout();

    @Autowired
    public ProfileView(UserProfileRepository userProfileRepository, I18NProvider I18nProvider) {
        this.userProfileRepository = userProfileRepository;
        this.I18nProvider = I18nProvider;
        this.setAlignItems(FlexComponent.Alignment.START);
        this.setSpacing(true);
    }

    @PostConstruct
    private void setup() {
        this.additionalComponents.stream().sorted().map(ComponentSource::getComponent).forEach(xva$0 -> this.add(new Component[]{xva$0}));
        if (this.I18nProvider != null) {
            this.createLanguageSelect();
        }
        this.createLogoutSection();
        this.createEndSection();
    }

    private void createEndSection() {
        this.endSection.setPadding(false);
        this.endSection.setWidthFull();
        this.endSection.addClassNames(new String[]{"items-end", "justify-between"});
        this.add(new Component[]{new Hr()});
        this.add(new Component[]{this.endSection});
    }

    private void createLogoutSection() {
        Button logoutButton = new Button(this.getTranslation("common.logout", new Object[0]), (Component)VaadinIcon.SIGN_OUT.create(), (ComponentEventListener & Serializable)click -> {
            UI.getCurrent().getPage().setLocation("/login");
            SecurityContextLogoutHandler logoutHandler = new SecurityContextLogoutHandler();
            logoutHandler.logout(VaadinServletRequest.getCurrent().getHttpServletRequest(), null, null);
        });
        this.endSection.add(new Component[]{logoutButton});
    }

    private void createLanguageSelect() {
        List<Locale> availableLocales = this.I18nProvider.getProvidedLocales();
        List<Locale> cleanedLocaled = availableLocales.stream().map(l -> {
            if (l.equals(Locale.ROOT)) {
                return Locale.ENGLISH;
            }
            return l;
        }).toList();
        availableLocales = cleanedLocaled.stream().filter(l -> {
            if (StringUtils.isNullOrEmpty((String)l.getCountry())) {
                return cleanedLocaled.stream().noneMatch(x -> x.getLanguage().equals(l.getLanguage()) && StringUtils.hasText((String)x.getCountry()));
            }
            return true;
        }).distinct().toList();
        this.languageSelect.setLabel(this.getTranslation("profile.languageSelect", new Object[0]));
        this.languageSelect.setItemLabelGenerator((ItemLabelGenerator & Serializable)l -> l.getDisplayName(Locale.ROOT));
        this.languageSelect.setItems(availableLocales);
        this.languageSelect.setValue((Object)this.getLocale());
        this.languageSelect.addValueChangeListener((HasValue.ValueChangeListener & Serializable)valueChangeEvent -> {
            Locale value = (Locale)valueChangeEvent.getValue();
            if (value == null) {
                return;
            }
            UserProfile user = this.userProfileRepository.findOrCreateUserProfile();
            user.setLanguage(value.toLanguageTag());
            this.userProfileRepository.save(user);
            UI.getCurrent().getPage().reload();
        });
        this.endSection.add(new Component[]{this.languageSelect});
    }
}

