/*
 * Decompiled with CFR 0.152.
 */
package fi.evolver.azure.entraid;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JOSEObjectType;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.JWSSigner;
import com.nimbusds.jose.crypto.factories.DefaultJWSSignerFactory;
import com.nimbusds.jose.jwk.JWK;
import com.nimbusds.jose.jwk.RSAKey;
import com.nimbusds.jose.util.Base64URL;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.SignedJWT;
import fi.evolver.azure.entraid.EntraIdAssertionException;
import java.io.ByteArrayInputStream;
import java.security.KeyFactory;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Base64;
import java.util.Date;
import java.util.UUID;

public class EntraIdCertificateSignedJwtAssertionFactory {
    private final JWSSigner signer;
    private final JWSHeader header;
    private final JWTClaimsSet templateClaims;

    public EntraIdCertificateSignedJwtAssertionFactory(String privateKeyPEM, String certificatePEM, String tenantId, String clientId) throws EntraIdAssertionException {
        try {
            byte[] decodedKey = Base64.getDecoder().decode(privateKeyPEM);
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(decodedKey);
            PrivateKey privateKey = keyFactory.generatePrivate(keySpec);
            byte[] decodedCert = Base64.getDecoder().decode(certificatePEM);
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            X509Certificate x509Certificate = (X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(decodedCert));
            PublicKey publicKey = x509Certificate.getPublicKey();
            this.signer = EntraIdCertificateSignedJwtAssertionFactory.createJWSSigner(publicKey, privateKey);
            this.header = EntraIdCertificateSignedJwtAssertionFactory.createJWSHeader(x509Certificate);
            this.templateClaims = EntraIdCertificateSignedJwtAssertionFactory.createTemplateJWTClaims(tenantId, clientId);
        }
        catch (JOSEException | NoSuchAlgorithmException | CertificateException | InvalidKeySpecException exception) {
            throw new EntraIdAssertionException("Failed to create factory.", exception);
        }
    }

    public String createJwtAssertion() throws EntraIdAssertionException {
        JWTClaimsSet claims = this.createJWTClaimsSet();
        SignedJWT signedJwt = new SignedJWT(this.header, claims);
        try {
            signedJwt.sign(this.signer);
        }
        catch (JOSEException exception) {
            throw new EntraIdAssertionException("Failed to sign JWT.", exception);
        }
        return signedJwt.serialize();
    }

    private static JWSSigner createJWSSigner(PublicKey publicKey, PrivateKey privateKey) throws JOSEException {
        RSAKey jwk = new RSAKey.Builder((RSAPublicKey)publicKey).privateKey(privateKey).keyID(UUID.randomUUID().toString()).build();
        return new DefaultJWSSignerFactory().createJWSSigner((JWK)jwk);
    }

    private static JWSHeader createJWSHeader(X509Certificate x509Certificate) throws CertificateEncodingException, NoSuchAlgorithmException {
        return new JWSHeader.Builder(JWSAlgorithm.RS256).type(JOSEObjectType.JWT).x509CertThumbprint(Base64URL.encode((byte[])EntraIdCertificateSignedJwtAssertionFactory.getX5t(x509Certificate))).build();
    }

    private static byte[] getX5t(X509Certificate cert) throws NoSuchAlgorithmException, CertificateEncodingException {
        MessageDigest digest = MessageDigest.getInstance("SHA-1");
        byte[] der = cert.getEncoded();
        digest.update(der);
        return digest.digest();
    }

    private static JWTClaimsSet createTemplateJWTClaims(String tenantId, String clientId) {
        return new JWTClaimsSet.Builder().audience("https://login.microsoftonline.com/%s/v2.0".formatted(tenantId)).issuer(clientId).subject(clientId).build();
    }

    private JWTClaimsSet createJWTClaimsSet() {
        Date currentTime = new Date();
        return new JWTClaimsSet.Builder(this.templateClaims).expirationTime(Date.from(currentTime.toInstant().plusSeconds(300L))).jwtID(UUID.randomUUID().toString()).notBeforeTime(currentTime).issueTime(currentTime).build();
    }
}

