/*
 * Decompiled with CFR 0.152.
 */
package fi.evolver.azure.entraid;

import fi.evolver.azure.entraid.EntraIdAssertionException;
import fi.evolver.azure.entraid.EntraIdCertificateSignedJwtAssertionFactory;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.convert.converter.Converter;
import org.springframework.security.oauth2.client.endpoint.AbstractOAuth2AuthorizationGrantRequest;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.core.ClientAuthenticationMethod;
import org.springframework.util.Assert;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

public class EntraIdJwtClientAuthenticationParametersConverter<T extends AbstractOAuth2AuthorizationGrantRequest>
implements Converter<T, MultiValueMap<String, String>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(EntraIdJwtClientAuthenticationParametersConverter.class);
    private static final String CLIENT_ASSERTION_TYPE_VALUE = "urn:ietf:params:oauth:client-assertion-type:jwt-bearer";
    private final Map<String, EntraIdCertificateSignedJwtAssertionFactory> factories;

    public EntraIdJwtClientAuthenticationParametersConverter(Map<String, EntraIdCertificateSignedJwtAssertionFactory> factories) {
        this.factories = factories;
    }

    public MultiValueMap<String, String> convert(T authorizationGrantRequest) {
        Assert.notNull(authorizationGrantRequest, (String)"authorizationGrantRequest cannot be null");
        ClientRegistration registration = authorizationGrantRequest.getClientRegistration();
        ClientAuthenticationMethod method = registration.getClientAuthenticationMethod();
        if (!ClientAuthenticationMethod.PRIVATE_KEY_JWT.equals((Object)method)) {
            return null;
        }
        try {
            return this.createParameters(registration);
        }
        catch (EntraIdAssertionException exception) {
            LOGGER.error("Failed to create parameters.", (Throwable)exception);
            return null;
        }
    }

    private MultiValueMap<String, String> createParameters(ClientRegistration registration) throws EntraIdAssertionException {
        LinkedMultiValueMap parameters = new LinkedMultiValueMap();
        parameters.set((Object)"client_assertion_type", (Object)CLIENT_ASSERTION_TYPE_VALUE);
        parameters.set((Object)"client_assertion", (Object)this.createAssertion(registration));
        return parameters;
    }

    private String createAssertion(ClientRegistration registration) throws EntraIdAssertionException {
        return this.factories.get(registration.getRegistrationId()).createJwtAssertion();
    }
}

