/*
 * Decompiled with CFR 0.152.
 */
package fi.testee.classpath;

import fi.testee.classpath.AnnotationScanner;
import fi.testee.classpath.ClasspathResource;
import fi.testee.classpath.JavaArchive;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.net.URL;
import java.util.Collection;
import java.util.HashSet;
import org.apache.commons.lang3.StringUtils;

abstract class AbstractBaseJavaArchive
implements JavaArchive {
    private Collection<String> classes;
    private final AnnotationScanner annotationScanner;

    protected AbstractBaseJavaArchive(URL ... urls) {
        this.annotationScanner = new AnnotationScanner(urls);
    }

    @Override
    public final synchronized ClasspathResource findResource(String s) {
        Callback<ClasspathResource> cb = (is, name) -> {
            if (name.equals(s)) {
                return new ClasspathResource(is);
            }
            return null;
        };
        return this.iterate(cb);
    }

    @Override
    public final synchronized Collection<String> getClasses() {
        if (this.classes != null) {
            return this.classes;
        }
        this.classes = new HashSet<String>();
        this.iterate((is, name) -> {
            if (name.endsWith(".class")) {
                this.classes.add(StringUtils.removeEnd((String)name.replace("/", "."), (String)".class"));
            }
            return null;
        });
        return this.classes;
    }

    protected abstract <T> T iterate(Callback<T> var1);

    @Override
    public Collection<Class<?>> annotatedWith(Class<? extends Annotation>[] annotations) {
        return this.annotationScanner.scanFor(annotations);
    }

    protected static interface Callback<T> {
        public T item(JavaArchive.InputStreamSupplier var1, String var2) throws IOException;
    }
}

