/*
 * Decompiled with CFR 0.152.
 */
package fi.testee.classpath;

import fi.testee.exceptions.TestEEfiException;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.scannotation.AnnotationDB;

public class AnnotationScanner {
    private final URL[] urls;
    private Map<String, Set<String>> index;

    public AnnotationScanner(URL ... urls) {
        this.urls = urls;
    }

    public Collection<Class<?>> scanFor(Class<? extends Annotation> ... annotations) {
        ArrayList ret = new ArrayList();
        Arrays.stream(annotations).forEach(annotation -> {
            Set<String> classNames = this.index().get(annotation.getName());
            if (classNames != null) {
                classNames.forEach(clazz -> {
                    try {
                        ret.add(Class.forName(clazz));
                    }
                    catch (ClassNotFoundException e) {
                        throw new TestEEfiException("Failed to load class", (Throwable)e);
                    }
                });
            }
        });
        return ret;
    }

    private synchronized Map<String, Set<String>> index() {
        if (this.index == null) {
            AnnotationDB db = new AnnotationDB();
            try {
                db.scanArchives(this.urls);
            }
            catch (IOException e) {
                throw new TestEEfiException("Failed to perform annotation scanning", (Throwable)e);
            }
            this.index = db.getAnnotationIndex();
        }
        return this.index;
    }
}

