/*
 * Decompiled with CFR 0.152.
 */
package fi.testee.classpath;

import fi.testee.utils.UrlUtils;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassLoaderAnalyzer {
    private static final Logger LOG = LoggerFactory.getLogger(ClassLoaderAnalyzer.class);

    private ClassLoaderAnalyzer() {
    }

    public static Set<URL> getClasspath(ClassLoader classLoader) {
        LOG.trace("System properties: {}", (Object)System.getProperties());
        Set<URL> collect = ClassLoaderAnalyzer.collectFromClasspath(classLoader);
        collect.addAll(ClassLoaderAnalyzer.collectFromLibraryPath());
        return collect;
    }

    private static Set<URL> collectFromLibraryPath() {
        return Arrays.stream(StringUtils.split((String)System.getProperty("java.class.path"), (char)File.pathSeparatorChar)).map(it -> new File((String)it).getAbsoluteFile()).filter(File::exists).map(UrlUtils::toUrl).collect(Collectors.toSet());
    }

    private static Set<URL> collectFromClasspath(ClassLoader classLoader) {
        if (!(classLoader instanceof URLClassLoader)) {
            return Collections.emptySet();
        }
        HashSet<URL> ret = new HashSet<URL>();
        ret.addAll(Arrays.stream(((URLClassLoader)classLoader).getURLs()).map(ClassLoaderAnalyzer::collectTransitive).flatMap(Collection::stream).collect(Collectors.toSet()));
        if (classLoader.getParent() != classLoader && classLoader.getParent() != null) {
            ret.addAll(ClassLoaderAnalyzer.collectFromClasspath(classLoader.getParent()));
        }
        return ret;
    }

    private static List<URL> collectTransitive(URL start) {
        File startFile = new File(start.getFile());
        if (!startFile.exists()) {
            return Collections.emptyList();
        }
        ArrayList<URL> ret = new ArrayList<URL>();
        ret.add(start);
        if (startFile.isFile()) {
            ClassLoaderAnalyzer.getClassPathsFromManifest(start).stream().map(ClassLoaderAnalyzer::collectTransitive).forEach(ret::addAll);
        }
        return ret;
    }

    private static List<URL> getClassPathsFromManifest(URL jarUrl) {
        try {
            String classPath = ClassLoaderAnalyzer.safeGetClassPath(new JarFile(jarUrl.getFile()));
            if (!StringUtils.isBlank((CharSequence)classPath)) {
                StringTokenizer tokenizer = new StringTokenizer(classPath);
                ArrayList<URL> urls = new ArrayList<URL>(tokenizer.countTokens());
                while (tokenizer.hasMoreTokens()) {
                    urls.add(new URL(jarUrl, tokenizer.nextToken()));
                }
                return urls;
            }
        }
        catch (IOException e) {
            LOG.warn("Could not open JAR for URL " + jarUrl, (Throwable)e);
        }
        return Collections.emptyList();
    }

    private static String safeGetClassPath(JarFile jar) throws IOException {
        Manifest mf = jar.getManifest();
        if (mf != null && mf.getMainAttributes() != null) {
            return mf.getMainAttributes().getValue(Attributes.Name.CLASS_PATH);
        }
        return null;
    }
}

