/*
 * Decompiled with CFR 0.152.
 */
package fi.testee.classpath;

import fi.testee.classpath.ClassLoaderAnalyzer;
import fi.testee.classpath.DirectoryJavaArchive;
import fi.testee.classpath.JarJavaArchive;
import fi.testee.classpath.JavaArchive;
import fi.testee.utils.UrlUtils;
import java.io.File;
import java.net.URL;
import java.util.Collection;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Classpath {
    private static final Logger LOG = LoggerFactory.getLogger(Classpath.class);
    private final ClassLoader classLoader;
    private Collection<JavaArchive> entries;

    public Classpath(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public synchronized Collection<JavaArchive> getAll() {
        if (this.entries == null) {
            this.entries = ClassLoaderAnalyzer.getClasspath(this.classLoader).stream().peek(entry -> LOG.trace("Classpath entry: {}", (Object)entry.getFile())).filter(url -> UrlUtils.toFile((URL)url).exists()).peek(entry -> LOG.trace("Existing classpath entry: {}", entry)).map(Classpath::toClasspathEntry).collect(Collectors.toSet());
        }
        return this.entries;
    }

    private static JavaArchive toClasspathEntry(URL url) {
        File file = UrlUtils.toFile((URL)url);
        if (file.isDirectory()) {
            return new DirectoryJavaArchive(file);
        }
        return new JarJavaArchive(file);
    }
}

