/*
 * Decompiled with CFR 0.152.
 */
package fi.testee.classpath;

import fi.testee.classpath.CompositeJavaArchive;
import fi.testee.classpath.DirectoryJavaArchive;
import fi.testee.classpath.JarJavaArchive;
import fi.testee.classpath.JavaArchive;
import fi.testee.exceptions.TestEEfiException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.HashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClasspathTransform {
    private static final Logger LOG = LoggerFactory.getLogger(ClasspathTransform.class);

    private ClasspathTransform() {
    }

    public static Collection<JavaArchive> transform(Collection<JavaArchive> in) {
        HashSet<JavaArchive> ret = new HashSet<JavaArchive>();
        in.stream().filter(it -> it instanceof JarJavaArchive).forEach(ret::add);
        in.stream().filter(it -> it instanceof DirectoryJavaArchive).peek(it -> LOG.trace("Processing directory java archive{}", it)).map(it -> (DirectoryJavaArchive)it).filter(it -> ClasspathTransform.getBuildDir(it) != null).collect(Collectors.groupingBy(ClasspathTransform::getBuildDir)).entrySet().stream().map(it -> new CompositeJavaArchive((Collection)it.getValue())).forEach(ret::add);
        in.stream().filter(it -> it instanceof DirectoryJavaArchive).map(it -> (DirectoryJavaArchive)it).filter(it -> ClasspathTransform.getBuildDir(it) == null).forEach(ret::add);
        return ret;
    }

    private static URL getBuildDir(DirectoryJavaArchive it) {
        return ClasspathTransform.getBuildDir(it.getURL().toExternalForm());
    }

    private static URL getBuildDir(String path) {
        Pattern pattern = Pattern.compile("(.*/build/)[^/]+(/[^/]+/)");
        Matcher matcher = pattern.matcher(path);
        if (!matcher.matches()) {
            return null;
        }
        try {
            return new URL(matcher.group(1) + "[any]" + matcher.group(2));
        }
        catch (MalformedURLException e) {
            throw new TestEEfiException("Failed to build composite java archive URL", (Throwable)e);
        }
    }
}

