/*
 * Decompiled with CFR 0.152.
 */
package fi.testee.classpath;

import fi.testee.classpath.ClasspathResource;
import fi.testee.classpath.JavaArchive;
import fi.testee.utils.UrlUtils;
import java.lang.annotation.Annotation;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.stream.Collectors;

public class CompositeJavaArchive
implements JavaArchive {
    private final Collection<JavaArchive> archives;
    private final URL url;

    public CompositeJavaArchive(Collection<? extends JavaArchive> archives) {
        this.archives = Collections.unmodifiableCollection(archives);
        this.url = UrlUtils.createCompositeUrl(archives.stream().map(JavaArchive::getURL).collect(Collectors.toList()));
    }

    @Override
    public ClasspathResource findResource(String s) {
        for (JavaArchive archive : this.archives) {
            ClasspathResource ret = archive.findResource(s);
            if (ret == null) continue;
            return ret;
        }
        return null;
    }

    @Override
    public URL getURL() {
        return this.url;
    }

    @Override
    public Collection<String> getClasses() {
        return this.archives.stream().map(JavaArchive::getClasses).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    @Override
    public Collection<Class<?>> annotatedWith(Class<? extends Annotation>[] annotations) {
        return this.archives.stream().map(it -> it.annotatedWith(annotations)).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    public String toString() {
        return "CompositeJavaArchive{archives=" + this.archives + ", url=" + this.url + '}';
    }
}

