/*
 * Decompiled with CFR 0.152.
 */
package fi.testee.classpath;

import fi.testee.classpath.AbstractBaseJavaArchive;
import fi.testee.exceptions.TestEEfiException;
import fi.testee.utils.UrlUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class DirectoryJavaArchive
extends AbstractBaseJavaArchive {
    private File file;

    public DirectoryJavaArchive(File file) {
        super(UrlUtils.toUrl((File)file));
        this.file = file;
    }

    @Override
    public URL getURL() {
        return UrlUtils.toUrl((File)this.file);
    }

    @Override
    protected <T> T iterate(AbstractBaseJavaArchive.Callback<T> cb) {
        return DirectoryJavaArchive.iterate(Collections.emptyList(), this.file, cb);
    }

    private static <T> T iterate(List<String> prefix, File file, AbstractBaseJavaArchive.Callback<T> cb) {
        try {
            T result = cb.item(() -> new FileInputStream(file), StringUtils.join(prefix, (String)"/") + "/" + file.getName());
            if (result != null) {
                return result;
            }
            for (File child : file.listFiles()) {
                T childResult;
                if (!(child.isDirectory() ? (childResult = DirectoryJavaArchive.iterate(DirectoryJavaArchive.prefix(prefix, child.getName()), child, cb)) != null : (childResult = cb.item(() -> new FileInputStream(child), StringUtils.join(prefix, (String)"/") + "/" + child.getName())) != null)) continue;
                return childResult;
            }
        }
        catch (IOException e) {
            throw new TestEEfiException("Error iterating classpath", (Throwable)e);
        }
        return null;
    }

    private static List<String> prefix(List<String> prefix, String name) {
        ArrayList<String> ret = new ArrayList<String>(prefix);
        ret.add(name);
        return ret;
    }

    public String toString() {
        return "DirectoryClasspathEntry{file=" + this.file + '}';
    }
}

