/*
 * Decompiled with CFR 0.152.
 */
package fi.testee.classpath;

import fi.testee.classpath.AbstractBaseJavaArchive;
import fi.testee.classpath.JavaArchive;
import fi.testee.exceptions.TestEEfiException;
import fi.testee.utils.UrlUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class JarJavaArchive
extends AbstractBaseJavaArchive {
    private final File file;

    public JarJavaArchive(File file) {
        super(UrlUtils.toUrl((File)file));
        this.file = file;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected <T> T iterate(AbstractBaseJavaArchive.Callback<T> cb) {
        try (ZipInputStream zis = new ZipInputStream(new FileInputStream(this.file));){
            ZipEntry entry = zis.getNextEntry();
            while (entry != null) {
                T ret = cb.item(this.streamProvider(entry), entry.getName());
                if (ret != null) {
                    T t = ret;
                    return t;
                }
                entry = zis.getNextEntry();
            }
            T t = null;
            return t;
        }
        catch (IOException e) {
            throw new TestEEfiException("Could not read JAR file " + this.file.getAbsolutePath(), (Throwable)e);
        }
    }

    private JavaArchive.InputStreamSupplier streamProvider(ZipEntry needle) {
        return () -> {
            ZipInputStream zis = new ZipInputStream(new FileInputStream(this.file));
            while (!zis.getNextEntry().getName().equals(needle.getName())) {
            }
            return zis;
        };
    }

    @Override
    public URL getURL() {
        return UrlUtils.toUrl((File)this.file);
    }

    public String toString() {
        return "JarClasspathEntry{file=" + this.file + '}';
    }
}

