/*
 * Decompiled with CFR 0.152.
 */
package fi.testee.deployment;

import fi.testee.classpath.JavaArchive;
import fi.testee.deployment.EjbDescriptorImpl;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.stream.Collectors;
import javax.ejb.Singleton;
import javax.ejb.Stateful;
import javax.ejb.Stateless;
import javax.persistence.Entity;

public class BeanArchive {
    private final JavaArchive classpathEntry;
    private final Collection<Class<? extends Annotation>> qualifyingAnnotations;
    private Collection<EjbDescriptorImpl<?>> ejbs;

    public BeanArchive(JavaArchive javaArchive, Collection<Class<? extends Annotation>> qualifyingAnnotations) {
        this.classpathEntry = javaArchive;
        this.qualifyingAnnotations = qualifyingAnnotations;
    }

    private <T> EjbDescriptorImpl<T> toEjbDescriptor(Class<T> clazz) {
        return new EjbDescriptorImpl<T>(clazz);
    }

    public Collection<String> getBeanClasses() {
        return this.classpathEntry.getClasses();
    }

    public synchronized Collection<EjbDescriptorImpl<?>> getEjbs() {
        if (this.ejbs == null) {
            this.ejbs = this.classpathEntry.annotatedWith(Singleton.class, Stateless.class, Stateful.class).stream().map(this::toEjbDescriptor).collect(Collectors.toSet());
        }
        return this.ejbs;
    }

    private boolean isEjbArchive() {
        return !this.classpathEntry.annotatedWith(Singleton.class, Stateless.class, Stateful.class, Entity.class).isEmpty();
    }

    public JavaArchive getClasspathEntry() {
        return this.classpathEntry;
    }

    public boolean isRelevant() {
        return this.hasBeansXml() || this.hasCdiExtension() || this.isEjbArchive() || this.hasAdditionalQualification();
    }

    private boolean hasAdditionalQualification() {
        return !this.classpathEntry.annotatedWith(this.qualifyingAnnotations.toArray(new Class[0])).isEmpty();
    }

    private boolean hasCdiExtension() {
        return this.getClasspathEntry().findResource("META-INF/services/javax.enterprise.inject.spi.CDIProvider") != null;
    }

    private boolean hasBeansXml() {
        return this.getClasspathEntry().findResource("META-INF/beans.xml") != null;
    }

    public String toString() {
        return "BeanArchive{classpathEntry=" + this.classpathEntry + '}';
    }

    public Collection<Class<?>> getClassesWith(Class<? extends Annotation> annotation) {
        return this.classpathEntry.annotatedWith(annotation);
    }
}

