/*
 * Decompiled with CFR 0.152.
 */
package fi.testee.deployment;

import fi.testee.classpath.Classpath;
import fi.testee.classpath.ClasspathTransform;
import fi.testee.classpath.JavaArchive;
import fi.testee.deployment.BeanArchive;
import fi.testee.deployment.EjbDescriptorImpl;
import fi.testee.spi.QualifyingAnnotationExtension;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.HashSet;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeanArchiveDiscovery {
    private static final Logger LOG = LoggerFactory.getLogger(BeanArchiveDiscovery.class);
    private final Collection<BeanArchive> beanArchives;

    public synchronized Collection<BeanArchive> getBeanArchives() {
        return this.beanArchives;
    }

    public BeanArchiveDiscovery() {
        long start = System.currentTimeMillis();
        Classpath cp = new Classpath(BeanArchiveDiscovery.class.getClassLoader());
        Collection<JavaArchive> classpathEntries = cp.getAll();
        Collection<JavaArchive> transformed = ClasspathTransform.transform(classpathEntries);
        Collection<Class<? extends Annotation>> qualifyingAnnotations = this.collectQualifyingAnnotations();
        LOG.debug("Additional qualifying annotations: {}", qualifyingAnnotations);
        this.beanArchives = transformed.parallelStream().map(it -> new BeanArchive((JavaArchive)it, qualifyingAnnotations)).filter(BeanArchive::isRelevant).peek(archive -> LOG.trace("Relevant bean archive: {}", (Object)archive.getClasspathEntry().getURL())).collect(Collectors.toSet());
        LOG.debug("Bean archive discovery completed in {}ms", (Object)(System.currentTimeMillis() - start));
    }

    private Collection<Class<? extends Annotation>> collectQualifyingAnnotations() {
        HashSet<Class<? extends Annotation>> ret = new HashSet<Class<? extends Annotation>>();
        ServiceLoader.load(QualifyingAnnotationExtension.class).iterator().forEachRemaining(it -> ret.addAll(it.getQualifyingAnnotations()));
        return ret;
    }

    public Set<EjbDescriptorImpl<?>> getSessionBeans() {
        return this.beanArchives.stream().map(BeanArchive::getEjbs).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    public Collection<Class<?>> getClassesWith(Class<? extends Annotation> annotation) {
        return this.beanArchives.stream().map(it -> it.getClassesWith(annotation)).flatMap(Collection::stream).collect(Collectors.toSet());
    }
}

