/*
 * Decompiled with CFR 0.152.
 */
package fi.testee.deployment;

import fi.testee.classpath.ClasspathResource;
import fi.testee.deployment.BeanArchive;
import fi.testee.exceptions.TestEEfiException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.jboss.weld.bootstrap.api.ServiceRegistry;
import org.jboss.weld.bootstrap.spi.BeanDeploymentArchive;
import org.jboss.weld.bootstrap.spi.BeansXml;
import org.jboss.weld.ejb.spi.EjbDescriptor;
import org.jboss.weld.xml.BeansXmlHandler;
import org.jboss.weld.xml.XmlSchema;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class BeanDeploymentArchiveImpl
implements BeanDeploymentArchive {
    private final ServiceRegistry serviceRegistry;
    private final BeanArchive beanArchive;
    private final Supplier<Collection<BeanDeploymentArchive>> archivesSupplier;
    private final BeansXml beansXml;

    public BeanDeploymentArchiveImpl(ServiceRegistry serviceRegistry, BeanArchive beanArchive, Supplier<Collection<BeanDeploymentArchive>> archivesSupplier) {
        this.serviceRegistry = serviceRegistry;
        this.beanArchive = beanArchive;
        this.archivesSupplier = archivesSupplier;
        ClasspathResource resource = beanArchive.getClasspathEntry().findResource("META-INF/beans.xml");
        this.beansXml = resource == null ? BeansXml.EMPTY_BEANS_XML : this.readBeansXml(beanArchive, resource);
    }

    private BeansXml readBeansXml(BeanArchive beanArchive, ClasspathResource resource) {
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setValidating(true);
            factory.setNamespaceAware(true);
            SAXParser parser = factory.newSAXParser();
            InputSource source = new InputSource(new ByteArrayInputStream(resource.getBytes()));
            if (source.getByteStream().available() == 0) {
                return BeansXml.EMPTY_BEANS_XML;
            }
            BeansXmlHandler handler = new BeansXmlHandler(beanArchive.getClasspathEntry().getURL());
            parser.setProperty("http://java.sun.com/xml/jaxp/properties/schemaLanguage", "http://www.w3.org/2001/XMLSchema");
            parser.setProperty("http://java.sun.com/xml/jaxp/properties/schemaSource", BeanDeploymentArchiveImpl.loadXsds());
            parser.parse(source, (DefaultHandler)handler);
            return handler.createBeansXml();
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            throw new TestEEfiException("Failed to parse META-INF/beans.xml in " + beanArchive.getClasspathEntry().getURL(), (Throwable)e);
        }
    }

    private static InputSource[] loadXsds() {
        return Arrays.stream(XmlSchema.values()).map(schema -> BeanDeploymentArchiveImpl.loadXsd(schema.getFileName(), schema.getClassLoader())).filter(Objects::nonNull).collect(Collectors.toSet()).toArray(new InputSource[0]);
    }

    private static InputSource loadXsd(String name, ClassLoader classLoader) {
        InputStream in = classLoader.getResourceAsStream(name);
        if (in == null) {
            return null;
        }
        return new InputSource(in);
    }

    public Collection<BeanDeploymentArchive> getBeanDeploymentArchives() {
        return this.archivesSupplier.get();
    }

    public Collection<String> getBeanClasses() {
        return this.beanArchive.getBeanClasses();
    }

    public BeansXml getBeansXml() {
        return this.beansXml;
    }

    public Collection<EjbDescriptor<?>> getEjbs() {
        return new HashSet(this.beanArchive.getEjbs());
    }

    public ServiceRegistry getServices() {
        return this.serviceRegistry;
    }

    public String getId() {
        return this.beanArchive.getClasspathEntry().getURL().toExternalForm();
    }
}

