/*
 * Decompiled with CFR 0.152.
 */
package fi.testee.deployment;

import fi.testee.deployment.BeanArchive;
import fi.testee.deployment.BeanArchiveDiscovery;
import fi.testee.deployment.BeanDeploymentArchiveImpl;
import java.util.Collection;
import java.util.HashSet;
import java.util.stream.Collectors;
import org.jboss.weld.bootstrap.api.ServiceRegistry;
import org.jboss.weld.bootstrap.spi.BeanDeploymentArchive;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeanDeploymentArchiveManagement {
    private static final Logger LOG = LoggerFactory.getLogger(BeanDeploymentArchiveManagement.class);
    private final BeanArchiveDiscovery beanArchiveDiscovery;
    private final ServiceRegistry serviceRegistry;
    private Collection<BeanDeploymentArchiveImpl> impls = null;
    private Collection<BeanDeploymentArchive> archives = null;

    public BeanDeploymentArchiveManagement(BeanArchiveDiscovery beanArchiveDiscovery, ServiceRegistry serviceRegistry) {
        this.beanArchiveDiscovery = beanArchiveDiscovery;
        this.serviceRegistry = serviceRegistry;
    }

    public synchronized Collection<BeanDeploymentArchiveImpl> getArchives() {
        if (this.impls == null) {
            this.impls = this.beanArchiveDiscovery.getBeanArchives().stream().peek(it -> LOG.debug("Found bean archive: {}", it)).map(it -> new BeanDeploymentArchiveImpl(this.serviceRegistry, (BeanArchive)it, () -> this.archives)).collect(Collectors.toSet());
            this.archives = new HashSet<BeanDeploymentArchiveImpl>(this.impls);
        }
        return this.impls;
    }
}

