/*
 * Decompiled with CFR 0.152.
 */
package fi.testee.deployment;

import fi.testee.deployment.BeanDeploymentArchiveManagement;
import fi.testee.deployment.WrappedBeanDeploymentArchive;
import fi.testee.spi.BeansXmlModifier;
import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;
import javax.enterprise.inject.spi.Extension;
import org.jboss.weld.bootstrap.api.ServiceRegistry;
import org.jboss.weld.bootstrap.spi.BeanDeploymentArchive;
import org.jboss.weld.bootstrap.spi.CDI11Deployment;
import org.jboss.weld.bootstrap.spi.Metadata;

public class DeploymentImpl
implements CDI11Deployment {
    public static final BeansXmlModifier UNMODIFIED = it -> it;
    private final ServiceRegistry serviceRegistry;
    private final Collection<Metadata<Extension>> extensions;
    private final Map<BeanDeploymentArchive, BeanDeploymentArchive> archives;

    public DeploymentImpl(BeanDeploymentArchiveManagement bdaManagement, ServiceRegistry serviceRegistry, Collection<Metadata<Extension>> extensions, BeansXmlModifier modifier) {
        this.archives = bdaManagement.getArchives().stream().collect(Collectors.toMap(it -> it, it -> new WrappedBeanDeploymentArchive((BeanDeploymentArchive)it, modifier, this::mapper)));
        this.serviceRegistry = serviceRegistry;
        this.extensions = extensions;
    }

    private BeanDeploymentArchive mapper(BeanDeploymentArchive bda) {
        return this.archives.get(bda);
    }

    public BeanDeploymentArchive getBeanDeploymentArchive(Class<?> aClass) {
        return this.loadBeanDeploymentArchive(aClass);
    }

    public Collection<BeanDeploymentArchive> getBeanDeploymentArchives() {
        return this.archives.values();
    }

    public BeanDeploymentArchive loadBeanDeploymentArchive(Class<?> aClass) {
        for (BeanDeploymentArchive archive : this.getBeanDeploymentArchives()) {
            if (!archive.getBeanClasses().contains(aClass.getName())) continue;
            return archive;
        }
        return null;
    }

    public ServiceRegistry getServices() {
        return this.serviceRegistry;
    }

    public Iterable<Metadata<Extension>> getExtensions() {
        return this.extensions;
    }
}

