/*
 * Decompiled with CFR 0.152.
 */
package fi.testee.deployment;

import fi.testee.deployment.InterceptorChain;
import fi.testee.ejb.EjbContainer;
import fi.testee.exceptions.TestEEfiException;
import fi.testee.spi.ReleaseCallbackHandler;
import fi.testee.spi.Releaser;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.ejb.Local;
import javax.ejb.Remove;
import javax.ejb.Singleton;
import javax.ejb.Stateful;
import javax.ejb.Stateless;
import javax.enterprise.inject.spi.InterceptionType;
import javax.enterprise.inject.spi.Interceptor;
import javax.interceptor.InvocationContext;
import org.jboss.weld.ejb.spi.BusinessInterfaceDescriptor;
import org.jboss.weld.ejb.spi.EjbDescriptor;
import org.jboss.weld.ejb.spi.InterceptorBindings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EjbDescriptorImpl<T>
implements EjbDescriptor<T> {
    private static final Logger LOG = LoggerFactory.getLogger(EjbDescriptorImpl.class);
    private final Collection<BusinessInterfaceDescriptor<?>> localBusinessInterfaces;
    private final Collection<BusinessInterfaceDescriptor<?>> remoteBusinessInterfaces;
    private final Class<T> clazz;
    private InterceptorBindings interceptorBindings;

    public EjbDescriptorImpl(Class<T> clazz) {
        LOG.trace("Creating EJB descriptor for {}", clazz);
        this.clazz = clazz;
        this.localBusinessInterfaces = new HashSet();
        this.remoteBusinessInterfaces = new HashSet();
        this.localBusinessInterfaces.add(() -> clazz);
        Arrays.stream(clazz.getInterfaces()).forEach(iface -> {
            if (iface.getAnnotation(Local.class) != null) {
                this.localBusinessInterfaces.add(() -> iface);
            }
            if (iface.getAnnotation(Remove.class) != null) {
                this.remoteBusinessInterfaces.add(() -> iface);
            }
        });
    }

    public Class<T> getBeanClass() {
        return this.clazz;
    }

    public Collection<BusinessInterfaceDescriptor<?>> getLocalBusinessInterfaces() {
        return this.localBusinessInterfaces;
    }

    public Collection<BusinessInterfaceDescriptor<?>> getRemoteBusinessInterfaces() {
        return this.remoteBusinessInterfaces;
    }

    public String getEjbName() {
        return this.getBeanClass().getName();
    }

    public Collection<Method> getRemoveMethods() {
        try {
            return Arrays.asList(this.getClass().getMethod("getRemoveMethods", new Class[0]));
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean isStateless() {
        return this.getBeanClass().getAnnotation(Stateless.class) != null;
    }

    public boolean isSingleton() {
        return this.getBeanClass().getAnnotation(Singleton.class) != null;
    }

    public boolean isStateful() {
        return this.getBeanClass().getAnnotation(Stateful.class) != null;
    }

    public boolean isMessageDriven() {
        return false;
    }

    public boolean isPassivationCapable() {
        return false;
    }

    public void setInterceptorBindings(InterceptorBindings interceptorBindings) {
        this.interceptorBindings = interceptorBindings;
    }

    public InterceptorChain getInterceptorChain(final EjbContainer.ContextFactory contextFactory) {
        return new InterceptorChain(){

            @Override
            public <T> Object invoke(Object target, Method method, Object[] args, InterceptorChain.ChainEnd<T> next, InterceptionType interceptionType) throws Throwable {
                if (EjbDescriptorImpl.this.interceptorBindings == null) {
                    return next.invoke();
                }
                return EjbDescriptorImpl.this.processInterceptorChain(new ArrayList(EjbDescriptorImpl.this.interceptorBindings.getAllInterceptors()), target, method, args, contextFactory, next, interceptionType);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> Object processInterceptorChain(List<Interceptor<?>> chain, Object target, Method method, Object[] args, EjbContainer.ContextFactory contextFactory, InterceptorChain.ChainEnd<T> next, InterceptionType interceptionType) throws Throwable {
        if (chain.isEmpty()) {
            return next.invoke();
        }
        Interceptor<?> it = chain.remove(0);
        Releaser releaser = new Releaser();
        try {
            Object object = this.intercept(it, it.create(contextFactory.create(it, (ReleaseCallbackHandler)releaser)), target, method, args, () -> this.processInterceptorChain(chain, target, method, args, contextFactory, next, interceptionType), interceptionType);
            return object;
        }
        finally {
            releaser.release();
        }
    }

    private <T> Object intercept(Interceptor<T> it, T instance, Object target, Method method, Object[] args, Proceed proceed, InterceptionType interceptionType) throws Exception {
        return it.intercept(interceptionType, instance, this.context(target, interceptionType == InterceptionType.AROUND_INVOKE ? method : null, args, proceed));
    }

    private InvocationContext context(final Object target, final Method method, final Object[] args, final Proceed proceed) {
        return new InvocationContext(){

            public Object getTarget() {
                return target;
            }

            public Object getTimer() {
                return null;
            }

            public Method getMethod() {
                return method;
            }

            public Constructor<?> getConstructor() {
                return null;
            }

            public Object[] getParameters() {
                return args;
            }

            public void setParameters(Object[] params) {
                throw new UnsupportedOperationException("Changing parameters is not supported, yet");
            }

            public Map<String, Object> getContextData() {
                return new HashMap<String, Object>();
            }

            public Object proceed() throws Exception {
                try {
                    return proceed.run();
                }
                catch (Exception e) {
                    throw e;
                }
                catch (Throwable throwable) {
                    throw new TestEEfiException("Failed to process interceptor chain", throwable);
                }
            }
        };
    }

    public String toString() {
        return "EjbDescriptorImpl for " + this.clazz;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (o instanceof EjbDescriptorImpl) {
            EjbDescriptorImpl that = (EjbDescriptorImpl)o;
            return this.clazz.equals(that.clazz);
        }
        if (o instanceof EjbDescriptor) {
            return o.equals(this);
        }
        return false;
    }

    public int hashCode() {
        return this.clazz.hashCode();
    }

    private static interface Proceed {
        public Object run() throws Throwable;
    }
}

