/*
 * Decompiled with CFR 0.152.
 */
package fi.testee.ejb;

import fi.testee.deployment.EjbDescriptorImpl;
import fi.testee.ejb.EjbDescriptorHolder;
import fi.testee.ejb.RootSessionBeanFactory;
import fi.testee.ejb.SessionBeanHolder;
import fi.testee.ejb.SessionBeanLifecycleListener;
import fi.testee.exceptions.TestEEfiException;
import fi.testee.spi.ReleaseCallbackHandler;
import fi.testee.spi.SessionBeanFactory;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.ejb.EJB;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.persistence.PersistenceContext;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.jboss.weld.context.CreationalContextImpl;
import org.jboss.weld.ejb.spi.EjbDescriptor;
import org.jboss.weld.injection.spi.ResourceReference;
import org.jboss.weld.injection.spi.ResourceReferenceFactory;
import org.jboss.weld.manager.BeanManagerImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EjbContainer {
    private static final Logger LOG = LoggerFactory.getLogger(EjbContainer.class);
    private final Set<SessionBeanHolder<?>> existingBeans = new HashSet();
    private Map<Type, EjbDescriptorImpl<?>> ejbDescriptors;
    private Map<EjbDescriptor<?>, ResourceReferenceFactory<?>> containers;
    public static final SessionBeanModifier IDENTITY = new IdentitySessionBeanModifier();

    public EjbContainer(Set<EjbDescriptorImpl<?>> ejbDescriptors) {
        this.ejbDescriptors = ejbDescriptors.stream().collect(Collectors.toMap(it -> it.getBeanClass(), it -> it));
    }

    public void init(EjbDescriptorHolderResolver holderResolver, Function<Object, Collection<ResourceReference<?>>> cdiInjection, Injection<Resource> resourceInjection, Injection<PersistenceContext> jpaInjection, SessionBeanModifier modifier, ContextFactory contextFactory) {
        LOG.debug("Starting EJB container with EJB descriptors {}", this.ejbDescriptors);
        EjbInjection injection = (o, b, m) -> {
            HashSet ret = new HashSet();
            ret.addAll((Collection)cdiInjection.apply(o));
            ret.addAll(this.ejbInjection(EJB.class, this::injectEjb).instantiateAll(o, b, m));
            ret.addAll(this.ejbInjection(Resource.class, this.injectResources(resourceInjection)).instantiateAll(o, b, m));
            ret.addAll(this.ejbInjection(PersistenceContext.class, this.injectResources(jpaInjection)).instantiateAll(o, b, m));
            return ret;
        };
        SessionBeanLifecycleListener lifecycleListener = new SessionBeanLifecycleListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void constructed(SessionBeanHolder<?> holder) {
                Set set = EjbContainer.this.existingBeans;
                synchronized (set) {
                    EjbContainer.this.existingBeans.add(holder);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void destroyed(SessionBeanHolder<?> holder) {
                Set set = EjbContainer.this.existingBeans;
                synchronized (set) {
                    EjbContainer.this.existingBeans.remove(holder);
                }
            }
        };
        this.containers = this.ejbDescriptors.values().stream().collect(Collectors.toMap(it -> it, it -> this.createFactory(holderResolver.resolve(it), injection, modifier, contextFactory, lifecycleListener).getResourceReferenceFactory()));
    }

    private ResourceReference<?> injectEjb(Object o, Field field, Bean<?> bean, BeanManager beanManager) {
        ResourceReference ref = this.createInstance(this.lookupDescriptor(field.getType())).createResource();
        this.inject(o, field, ref.getInstance());
        return ref;
    }

    private <T extends Annotation> Injector injectResources(Injection<T> injection) {
        return (o, f, b, m) -> {
            Object instance = injection.instantiate(f, b, m);
            this.inject(o, f, instance);
            return null;
        };
    }

    private EjbInjection ejbInjection(Class<? extends Annotation> annotationClass, Injector injector) {
        return (o, b, m) -> Arrays.stream(FieldUtils.getAllFields(o.getClass())).filter(f -> f.getAnnotation(annotationClass) != null).map(f -> injector.instantiate(o, (Field)f, (Bean<?>)b, m)).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    private void inject(Object o, Field field, Object instanceToInject) {
        try {
            field.setAccessible(true);
            field.set(o, instanceToInject);
        }
        catch (IllegalAccessException e) {
            throw new TestEEfiException("Failed to inject into field", (Throwable)e);
        }
    }

    private <T> SessionBeanFactory<T> createFactory(EjbDescriptorHolder<T> desc, EjbInjection injection, SessionBeanModifier modifier, ContextFactory contextFactory, SessionBeanLifecycleListener lifecycleListener) {
        RootSessionBeanFactory<T> root = new RootSessionBeanFactory<T>(injection, desc.getBean(), desc.getBeanManager(), desc.getDescriptor(), contextFactory, lifecycleListener);
        return modifier.modify(root);
    }

    public EjbDescriptor<?> lookupDescriptor(Type type) {
        return this.ejbDescriptors.get(type);
    }

    public <T> ResourceReferenceFactory<T> createInstance(EjbDescriptor<T> descriptor) {
        return () -> this.containers.get(descriptor).createResource();
    }

    public void shutdown() {
        while (!this.existingBeans.isEmpty()) {
            this.existingBeans.iterator().next().forceDestroy();
        }
    }

    private static class IdentitySessionBeanModifier
    implements SessionBeanModifier {
        private IdentitySessionBeanModifier() {
        }

        @Override
        public <T> SessionBeanFactory<T> modify(SessionBeanFactory<T> factory) {
            return factory;
        }
    }

    public static interface SessionBeanModifier {
        public <T> SessionBeanFactory<T> modify(SessionBeanFactory<T> var1);
    }

    static interface EjbInjection {
        public Collection<ResourceReference<?>> instantiateAll(Object var1, Bean<?> var2, BeanManagerImpl var3);
    }

    private static interface Injector {
        public ResourceReference<?> instantiate(Object var1, Field var2, Bean<?> var3, BeanManagerImpl var4);
    }

    public static interface ContextFactory {
        public <T> CreationalContextImpl<T> create(Contextual<T> var1, ReleaseCallbackHandler var2);
    }

    public static interface Injection<A extends Annotation> {
        public Object instantiate(Field var1, Bean<?> var2, BeanManagerImpl var3);
    }

    public static interface EjbDescriptorHolderResolver {
        public <T> EjbDescriptorHolder<T> resolve(EjbDescriptorImpl<T> var1);
    }
}

