/*
 * Decompiled with CFR 0.152.
 */
package fi.testee.ejb;

import fi.testee.deployment.EjbDescriptorImpl;
import fi.testee.ejb.EjbContainer;
import fi.testee.ejb.SessionBeanLifecycleListener;
import fi.testee.ejb.SingletonHolder;
import fi.testee.exceptions.TestEEfiException;
import fi.testee.spi.SessionBeanFactory;
import java.util.Collection;
import javax.enterprise.inject.spi.Bean;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.jboss.weld.bean.SessionBean;
import org.jboss.weld.ejb.spi.EjbDescriptor;
import org.jboss.weld.injection.spi.ResourceReference;
import org.jboss.weld.injection.spi.ResourceReferenceFactory;
import org.jboss.weld.manager.BeanManagerImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RootSessionBeanFactory<T>
implements SessionBeanFactory<T> {
    private static final Logger LOG = LoggerFactory.getLogger(RootSessionBeanFactory.class);
    private final EjbContainer.EjbInjection injection;
    private final SessionBean<T> bean;
    private final BeanManagerImpl beanManager;
    private final EjbDescriptorImpl<T> descriptor;
    private final EjbContainer.ContextFactory contextFactory;
    private SessionBeanLifecycleListener lifecycleListener;

    public RootSessionBeanFactory(EjbContainer.EjbInjection injection, SessionBean<T> bean, BeanManagerImpl beanManager, EjbDescriptorImpl<T> descriptor, EjbContainer.ContextFactory contextFactory, SessionBeanLifecycleListener lifecycleListener) {
        this.injection = injection;
        this.bean = bean;
        this.beanManager = beanManager;
        this.descriptor = descriptor;
        this.contextFactory = contextFactory;
        this.lifecycleListener = lifecycleListener;
    }

    public EjbDescriptor<T> getDescriptor() {
        return this.descriptor;
    }

    public ResourceReferenceFactory<T> getResourceReferenceFactory() {
        LOG.debug("Creating session bean holder for {}", this.descriptor.getBeanClass());
        SingletonHolder<T> singletonHolder = new SingletonHolder<T>(this.descriptor.getBeanClass(), this::createNewInstance, this.descriptor.getInterceptorChain(this.contextFactory));
        singletonHolder.addLifecycleListener(this.lifecycleListener);
        return singletonHolder;
    }

    private Pair<T, Collection<ResourceReference<?>>> createNewInstance() {
        LOG.debug("Creating new instance of {}", this.descriptor.getBeanClass());
        try {
            T t = this.descriptor.getBeanClass().newInstance();
            Collection<ResourceReference<?>> references = this.injection.instantiateAll(t, (Bean<?>)this.bean, this.beanManager);
            return new ImmutablePair(t, references);
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new TestEEfiException("Failed to instantiate session bean", (Throwable)e);
        }
    }
}

