/*
 * Decompiled with CFR 0.152.
 */
package fi.testee.ejb;

import fi.testee.deployment.InterceptorChain;
import fi.testee.ejb.SessionBeanHolder;
import fi.testee.exceptions.TestEEfiException;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.enterprise.inject.spi.InterceptionType;
import javax.inject.Provider;
import net.bytebuddy.ByteBuddy;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.InvocationHandlerAdapter;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import org.apache.commons.lang3.tuple.Pair;
import org.jboss.weld.injection.spi.ResourceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SingletonHolder<T>
extends SessionBeanHolder<T> {
    private static final Logger LOG = LoggerFactory.getLogger(SingletonHolder.class);
    private final Class<T> beanClass;
    private final Provider<Pair<T, Collection<ResourceReference<?>>>> factory;
    private final T proxyInstance;
    private T instance;
    private InterceptorChain chain;
    private int referenceCount = 0;
    private Collection<ResourceReference<?>> referenced;
    private boolean destroying;

    public SingletonHolder(Class<T> beanClass, Provider<Pair<T, Collection<ResourceReference<?>>>> factory, InterceptorChain chain) {
        this.beanClass = beanClass;
        this.factory = factory;
        this.proxyInstance = this.createProxy(beanClass, chain);
    }

    private T createProxy(Class<T> clazz, InterceptorChain chain) {
        this.chain = chain;
        try {
            InvocationHandler invocationHandler = (proxy, method, args) -> this.invokeIntercepted(args, this.instance(), method, InterceptionType.AROUND_INVOKE);
            Class dynamicType = new ByteBuddy().subclass(clazz).method((ElementMatcher)ElementMatchers.any()).intercept((Implementation)InvocationHandlerAdapter.of((InvocationHandler)invocationHandler)).make().load(this.getClass().getClassLoader()).getLoaded();
            return dynamicType.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new TestEEfiException("Failed to create proxy instance of " + clazz, (Throwable)e);
        }
    }

    private Object invokeIntercepted(Object[] args, T target, Method method, InterceptionType interceptionType) throws Throwable {
        return this.chain.invoke(target, method, args, () -> {
            try {
                return method.invoke(target, args);
            }
            catch (InvocationTargetException e) {
                throw e.getTargetException();
            }
        }, interceptionType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResourceReference<T> createResource() {
        SingletonHolder singletonHolder = this;
        synchronized (singletonHolder) {
            ++this.referenceCount;
            LOG.trace("Creating resource reference to {}, count is now {}", this.beanClass, (Object)this.referenceCount);
        }
        return new ResourceReference<T>(){

            public T getInstance() {
                return SingletonHolder.this.proxyInstance;
            }

            public void release() {
                this.releaseInstance().run();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private Runnable releaseInstance() {
                SingletonHolder singletonHolder = SingletonHolder.this;
                synchronized (singletonHolder) {
                    SingletonHolder.this.referenceCount = SingletonHolder.this.referenceCount - 1;
                    LOG.trace("Releasing resource reference to {}, count is now {}", (Object)SingletonHolder.this.beanClass, (Object)SingletonHolder.this.referenceCount);
                    if (SingletonHolder.this.referenceCount == 0) {
                        LOG.trace("Last reference to {} released, destroying", (Object)SingletonHolder.this.beanClass);
                        if (SingletonHolder.this.instance != null && !SingletonHolder.this.destroying) {
                            return SingletonHolder.this.destroy();
                        }
                        LOG.trace("Last reference to {} released but not instantiated anyway", (Object)SingletonHolder.this.beanClass);
                        SingletonHolder.this.instance = null;
                        SingletonHolder.this.referenced = null;
                    }
                }
                return () -> {};
            }
        };
    }

    private Runnable destroy() {
        T instanceToRelease = this.instance;
        return () -> {
            this.destroying = true;
            this.invoke(instanceToRelease, PreDestroy.class, InterceptionType.PRE_DESTROY);
            this.notifyListeners(it -> it.destroyed(this));
            this.referenced.forEach(ResourceReference::release);
        };
    }

    private synchronized T instance() {
        if (null == this.instance) {
            Pair pair = (Pair)this.factory.get();
            this.instance = pair.getLeft();
            this.referenced = (Collection)pair.getRight();
            this.invoke(this.instance, PostConstruct.class, InterceptionType.POST_CONSTRUCT);
            this.notifyListeners(it -> it.constructed(this));
        }
        return this.instance;
    }

    private void invoke(T t, Class<? extends Annotation> annotation, InterceptionType type) {
        for (Class<?> c = t.getClass(); c != null && c != Object.class; c = c.getSuperclass()) {
            this.invoke(t, c, annotation, type);
        }
    }

    private void invoke(T t, Class<?> c, Class<? extends Annotation> annotation, InterceptionType interceptionType) {
        Set candidates = Arrays.stream(c.getDeclaredMethods()).filter(it -> it.getAnnotation(annotation) != null).collect(Collectors.toSet());
        if (candidates.isEmpty()) {
            return;
        }
        if (candidates.size() > 1) {
            throw new TestEEfiException("Only one @" + annotation.getSimpleName() + " method is allowed per class");
        }
        Method method = (Method)candidates.iterator().next();
        method.setAccessible(true);
        try {
            this.invokeIntercepted(new Object[0], t, method, interceptionType);
        }
        catch (Throwable e) {
            throw new TestEEfiException("Failed to invoke @" + annotation.getSimpleName() + " method " + method, e);
        }
    }

    @Override
    public void forceDestroy() {
        this.destroy().run();
    }
}

