/*
 * Decompiled with CFR 0.152.
 */
package fi.testee.jdbc;

import fi.testee.exceptions.TestEEfiException;
import fi.testee.jdbc.ConnectionFactoryManager;
import fi.testee.jdbc.TestDataSource;
import fi.testee.jdbc.TesteeDataSource;
import fi.testee.spi.ConnectionFactory;
import fi.testee.spi.ResourceProvider;
import fi.testee.spi.scope.TestSetupScope;
import fi.testee.utils.AnnotationUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.PreDestroy;
import javax.annotation.Resource;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@TestSetupScope
public class JdbcResourceProvider
implements ResourceProvider {
    private static final Logger LOG = LoggerFactory.getLogger(JdbcResourceProvider.class);
    @Resource(mappedName="testeefi/setup/class")
    private Class<?> testSetupClass;
    @Resource(mappedName="testeefi/setup/connectionFactoryManager")
    private ConnectionFactoryManager connectionFactoryManager;
    @Resource(mappedName="testeefi/setup/rollbackTransactions")
    private boolean rollbackTransactions;
    private final Map<String, TesteeDataSource> dataSources = new HashMap<String, TesteeDataSource>();
    private Map<String, ConnectionFactory> connectionFactories;

    public Object resolve(InjectionPoint injectionPoint) {
        if (injectionPoint.getType() != DataSource.class) {
            return null;
        }
        Resource annotation = (Resource)injectionPoint.getAnnotated().getAnnotation(Resource.class);
        if (annotation == null) {
            return null;
        }
        return this.resolve(null, annotation.mappedName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object resolve(String jndiName, String mappedName) {
        JdbcResourceProvider jdbcResourceProvider = this;
        synchronized (jdbcResourceProvider) {
            if (!this.dataSources.containsKey(mappedName) && this.connectionFactories().containsKey(mappedName)) {
                Supplier<Connection> factory = () -> this.connectionFactories().get(mappedName).createConnection(this.testSetupClass.getName() + ":" + mappedName);
                this.dataSources.put(mappedName, new TesteeDataSource(mappedName, factory));
            }
            if (!this.dataSources.containsKey(mappedName)) {
                return null;
            }
            return this.dataSources.get(mappedName);
        }
    }

    private Map<String, ConnectionFactory> connectionFactories() {
        if (this.connectionFactories == null) {
            this.connectionFactories = this.discover(this.testSetupClass);
        }
        return this.connectionFactories;
    }

    private Map<String, ConnectionFactory> discover(Class<?> testClass) {
        return AnnotationUtils.collectAnnotations(testClass, TestDataSource.class).stream().collect(Collectors.toMap(TestDataSource::name, it -> this.connectionFactoryManager.getFactoryFor((TestDataSource)it)));
    }

    @PreDestroy
    public void shutdown() {
        this.dataSources.values().forEach(it -> {
            try {
                if (this.rollbackTransactions) {
                    LOG.trace("Rolling back {}", it);
                    it.rollback();
                } else {
                    LOG.trace("Committing {}", it);
                    it.commit();
                }
            }
            catch (SQLException e) {
                throw new TestEEfiException("Failed to shut down JDBC resources", (Throwable)e);
            }
        });
    }
}

