/*
 * Decompiled with CFR 0.152.
 */
package fi.testee.jdbc;

import fi.testee.exceptions.TestEEfiException;
import fi.testee.utils.JdbcUtils;
import fi.testee.utils.ProxyUtils;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Arrays;
import java.util.function.Supplier;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TesteeDataSource
implements DataSource {
    private static final Logger LOG = LoggerFactory.getLogger(TesteeDataSource.class);
    private final String name;
    private final Supplier<Connection> connectionFactory;
    private Connection connection;
    private PrintWriter out;
    private int loginTimeout;

    TesteeDataSource(String name, Supplier<Connection> connectionFactory) {
        this.name = name;
        this.connectionFactory = connectionFactory;
    }

    @Override
    public Connection getConnection() throws SQLException {
        return TesteeDataSource.safe((Connection)ProxyUtils.lazy(() -> {
            TesteeDataSource testeeDataSource = this;
            synchronized (testeeDataSource) {
                if (this.connection == null) {
                    LOG.debug("Creating connection {}", (Object)this.name);
                    this.connection = this.connectionFactory.get();
                    try {
                        this.connection.setAutoCommit(false);
                    }
                    catch (SQLException e) {
                        throw new TestEEfiException("Failed to set auto-commit to false on JDBC connection", (Throwable)e);
                    }
                }
                return this.connection;
            }
        }, Connection.class));
    }

    private static Connection safe(Connection connection) {
        return (Connection)Proxy.newProxyInstance(TesteeDataSource.class.getClassLoader(), new Class[]{Connection.class}, (proxy, method, args) -> {
            try {
                if (Arrays.asList("close", "commit", "rollback").contains(method.getName())) {
                    return null;
                }
                return method.invoke((Object)connection, args);
            }
            catch (InvocationTargetException e) {
                throw e.getTargetException();
            }
        });
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        return this.getConnection();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new SQLException("Don't know how to unwrap to " + iface.getName());
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return false;
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return this.out;
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
        this.out = out;
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        this.loginTimeout = seconds;
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return this.loginTimeout;
    }

    @Override
    public java.util.logging.Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException("JUL not used");
    }

    void rollback() throws SQLException {
        this.withConnection((JdbcUtils.JdbcConsumer<Connection>)((JdbcUtils.JdbcConsumer)c -> {
            LOG.debug("Rolling back connection {} on {}", (Object)this.name, (Object)this);
            c.rollback();
        }));
    }

    void commit() throws SQLException {
        this.withConnection((JdbcUtils.JdbcConsumer<Connection>)((JdbcUtils.JdbcConsumer)c -> {
            LOG.debug("Committing connection {} on {}", (Object)this.name, (Object)this);
            c.commit();
        }));
    }

    void close() throws SQLException {
        this.withConnection((JdbcUtils.JdbcConsumer<Connection>)((JdbcUtils.JdbcConsumer)c -> {
            LOG.debug("Closing connection to {} on {}", (Object)this.name, (Object)this);
            c.close();
        }));
    }

    private void withConnection(JdbcUtils.JdbcConsumer<Connection> runnable) throws SQLException {
        if (this.connection != null) {
            runnable.run((Object)this.connection);
        }
    }

    public String toString() {
        return "TesteeDataSource{name='" + this.name + '\'' + '}';
    }
}

