/*
 * Decompiled with CFR 0.152.
 */
package fi.testee.jpa;

import fi.testee.classpath.ClasspathResource;
import fi.testee.classpath.JavaArchive;
import fi.testee.deployment.BeanArchive;
import fi.testee.deployment.BeanArchiveDiscovery;
import fi.testee.exceptions.TestEEfiException;
import fi.testee.jpa.PersistenceUnitInfoImpl;
import fi.testee.utils.ProxyUtils;
import fi.testee.utils.UrlUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.persistence.spi.PersistenceUnitInfo;
import javax.persistence.spi.PersistenceUnitTransactionType;
import javax.sql.DataSource;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.jboss.weld.injection.spi.ResourceInjectionServices;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class PersistenceUnitDiscovery {
    private static final Logger LOG = LoggerFactory.getLogger(PersistenceUnitDiscovery.class);
    private static final DocumentBuilder BUILDER = PersistenceUnitDiscovery.createDocumentBuilder();
    private Map<String, ? extends PersistenceUnitInfo> units;
    private BeanArchiveDiscovery beanArchiveDiscovery;
    private ResourceInjectionServices resourceInjectionServices;

    public PersistenceUnitDiscovery(BeanArchiveDiscovery beanArchiveDiscovery, ResourceInjectionServices resourceInjectionServices) {
        this.beanArchiveDiscovery = beanArchiveDiscovery;
        this.resourceInjectionServices = resourceInjectionServices;
    }

    private static DocumentBuilder createDocumentBuilder() {
        try {
            return DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new TestEEfiException("Failed to initialize " + DocumentBuilder.class.getName(), (Throwable)e);
        }
    }

    private Collection<PersistenceUnitInfoImpl> unitsFrom(JavaArchive archive, ClasspathResource xml) {
        try {
            Document doc = BUILDER.parse(new ByteArrayInputStream(xml.getBytes()));
            Element root = doc.getDocumentElement();
            NodeList unitNodes = (NodeList)this.xpath().evaluate("//persistence/persistence-unit", root, XPathConstants.NODESET);
            HashSet<PersistenceUnitInfoImpl> ret = new HashSet<PersistenceUnitInfoImpl>();
            for (int i = 0; i < unitNodes.getLength(); ++i) {
                ret.add(this.createUnitInfo(archive, (Element)unitNodes.item(i)));
            }
            return ret;
        }
        catch (IOException | XPathExpressionException | SAXException e) {
            throw new TestEEfiException("Failed to read persistence.xml", (Throwable)e);
        }
    }

    private XPath xpath() {
        return XPathFactory.newInstance().newXPath();
    }

    private PersistenceUnitInfoImpl createUnitInfo(JavaArchive archive, Element unit) throws XPathExpressionException {
        XPath xpath = this.xpath();
        String name = unit.getAttribute("name");
        LOG.debug("Initializing persistence unit info for {}", (Object)name);
        String transactionType = unit.getAttribute("transaction-type");
        String provider = this.stringTag(unit, xpath, "provider");
        String jtaDataSourceName = this.stringTag(unit, xpath, "jta-data-source");
        String excludeUnlistedClassesString = this.stringTag(unit, xpath, "exclude-unlisted-classes");
        NodeList props = (NodeList)xpath.evaluate("properties/property", unit, XPathConstants.NODESET);
        Properties properties = new Properties();
        for (int i = 0; i < props.getLength(); ++i) {
            Element prop = (Element)props.item(i);
            String propName = prop.getAttribute("name");
            String propValue = prop.getAttribute("value");
            properties.put(propName, propValue);
        }
        List<URL> jarFileUrls = this.collectStringListElements(unit, xpath, "jar-file").stream().map(UrlUtils::toUrl).collect(Collectors.toList());
        List<String> mappingFileNames = this.collectStringListElements(unit, xpath, "mapping-file");
        List<String> managedClassNames = this.collectStringListElements(unit, xpath, "class");
        boolean excludeUnlistedClasses = excludeUnlistedClassesString != null && Boolean.parseBoolean(excludeUnlistedClassesString);
        return new PersistenceUnitInfoImpl(archive.getURL(), provider, name + "/" + UUID.randomUUID(), name, PersistenceUnitTransactionType.valueOf((String)transactionType), (DataSource)ProxyUtils.lazy(() -> this.resolveDataSource(jtaDataSourceName), DataSource.class), properties, jarFileUrls, mappingFileNames, managedClassNames, excludeUnlistedClasses, this.getClass().getClassLoader());
    }

    private String stringTag(Element element, XPath xpath, String tagName) throws XPathExpressionException {
        return (String)xpath.evaluate(tagName + "/text()", element, XPathConstants.STRING);
    }

    private List<String> collectStringListElements(Element unit, XPath xpath, String elementName) throws XPathExpressionException {
        NodeList nodes = (NodeList)xpath.evaluate(elementName, unit, XPathConstants.NODESET);
        ArrayList<String> strings = new ArrayList<String>();
        for (int i = 0; i < nodes.getLength(); ++i) {
            strings.add(nodes.item(i).getTextContent());
        }
        return strings;
    }

    private DataSource resolveDataSource(String dataSourceName) {
        Object result = this.resourceInjectionServices.registerResourceInjectionPoint(null, dataSourceName).createResource().getInstance();
        if (!(result instanceof DataSource)) {
            throw new TestEEfiException("The resolved container managed resource is not a DataSource: " + result);
        }
        return (DataSource)result;
    }

    public synchronized PersistenceUnitInfo findByUnitName(String unitName) {
        if (this.units == null) {
            this.units = this.discover();
        }
        return this.units.get(unitName);
    }

    private Map<String, PersistenceUnitInfoImpl> discover() {
        return this.beanArchiveDiscovery.getBeanArchives().stream().map(it -> new ImmutablePair(it, (Object)it.getClasspathEntry().findResource("META-INF/persistence.xml"))).filter(it -> it.getRight() != null).map(it -> this.unitsFrom(((BeanArchive)it.getLeft()).getClasspathEntry(), (ClasspathResource)it.getRight())).flatMap(Collection::stream).collect(Collectors.toMap(PersistenceUnitInfoImpl::getActualPersistenceUnitName, it -> it));
    }
}

