/*
 * Decompiled with CFR 0.152.
 */
package fi.testee.runtime;

import fi.testee.deployment.BeanArchiveDiscovery;
import fi.testee.deployment.BeanDeploymentArchiveManagement;
import fi.testee.deployment.DeploymentImpl;
import fi.testee.exceptions.TestEEfiException;
import fi.testee.services.TransactionServicesImpl;
import fi.testee.spi.BeansXmlModifier;
import fi.testee.spi.DependencyInjection;
import fi.testee.spi.ReleaseCallbackHandler;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.InjectionTarget;
import org.jboss.weld.Container;
import org.jboss.weld.bean.AbstractClassBean;
import org.jboss.weld.bootstrap.WeldBootstrap;
import org.jboss.weld.bootstrap.api.Bootstrap;
import org.jboss.weld.bootstrap.api.Environment;
import org.jboss.weld.bootstrap.api.Environments;
import org.jboss.weld.bootstrap.api.Service;
import org.jboss.weld.bootstrap.api.ServiceRegistry;
import org.jboss.weld.bootstrap.spi.Deployment;
import org.jboss.weld.bootstrap.spi.Metadata;
import org.jboss.weld.context.CreationalContextImpl;
import org.jboss.weld.context.api.ContextualInstance;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.transaction.spi.TransactionServices;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DependencyInjectionRealm
implements DependencyInjection {
    private static final Logger LOG = LoggerFactory.getLogger(DependencyInjectionRealm.class);
    private final String contextId = UUID.randomUUID().toString();
    private final CreationalContextImpl<Object> rootContext = new CreationalContextImpl(null);
    private Bootstrap bootstrap;
    private DeploymentImpl deployment;

    public DependencyInjectionRealm init(ServiceRegistry serviceRegistry, BeanArchiveDiscovery beanArchiveDiscovery, Environments environment, Collection<Metadata<Extension>> extensions, BeansXmlModifier beansXmlModifier) {
        LOG.trace("Starting dependency injection realm {}", (Object)this.contextId);
        this.ensureTransactionServices(serviceRegistry);
        BeanDeploymentArchiveManagement bdaManagement = new BeanDeploymentArchiveManagement(beanArchiveDiscovery, serviceRegistry);
        this.deployment = new DeploymentImpl(bdaManagement, serviceRegistry, extensions, beansXmlModifier);
        this.bootstrap = new WeldBootstrap().startContainer(this.contextId, (Environment)environment, (Deployment)this.deployment).startInitialization().deployBeans().validateBeans().endInitialization();
        return this;
    }

    public BeanManagerImpl findArchiveFor(Class<?> clazz) {
        return (BeanManagerImpl)this.container().beanDeploymentArchives().get(this.deployment.getBeanDeploymentArchive(clazz));
    }

    private void ensureTransactionServices(ServiceRegistry serviceRegistry) {
        if (serviceRegistry.get(TransactionServices.class) == null) {
            serviceRegistry.add(TransactionServices.class, (Service)new TransactionServicesImpl());
        }
    }

    void shutdown() {
        LOG.trace("Shutting down dependency injection realm {}", (Object)this.contextId);
        this.rootContext.release();
        this.bootstrap.shutdown();
    }

    private <T> Collection<Bean<T>> resolve(Class<T> clazz) {
        return this.deployment.getBeanDeploymentArchives().stream().map(arg_0 -> ((Bootstrap)this.bootstrap).getManager(arg_0)).map(archive -> this.beansOf(clazz, (BeanManagerImpl)archive)).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    private <T> Set<Bean<T>> beansOf(Class<T> clazz, BeanManagerImpl beanManager) {
        return beanManager.getBeans(clazz, new Annotation[0]).stream().map(bean -> bean).collect(Collectors.toSet());
    }

    private Container container() {
        return Container.instance((String)this.contextId);
    }

    public <T> Set<T> getInstancesOf(Class<T> clazz, ReleaseCallbackHandler handler) {
        return this.resolve(clazz).stream().map(it -> this.newInstance((Bean)it, handler)).collect(Collectors.toSet());
    }

    private <T> T newInstance(final Bean<T> bean, ReleaseCallbackHandler handler) {
        final CreationalContextImpl<T> ctx = this.contextFor((Contextual<T>)bean, handler);
        final Object instance = bean.create(ctx);
        ctx.addDependentInstance(new ContextualInstance<T>(){

            public T getInstance() {
                return instance;
            }

            public CreationalContext<T> getCreationalContext() {
                return ctx;
            }

            public Contextual<T> getContextual() {
                return bean;
            }
        });
        return (T)instance;
    }

    public <T> T getInstanceOf(Class<T> clazz, ReleaseCallbackHandler handler) {
        return this.unique(clazz, this.getInstancesOf(clazz, handler));
    }

    private <T> T unique(Class clazz, Collection<T> set) {
        if (set.isEmpty()) {
            Set allBeans = this.container().beanDeploymentArchives().values().stream().map(BeanManagerImpl::getBeans).flatMap(Collection::stream).collect(Collectors.toSet());
            throw new TestEEfiException("No matching bean found for class " + clazz.getName() + ", available beans are: " + allBeans);
        }
        if (set.size() > 1) {
            throw new TestEEfiException("Multiple ambiguous beans found for class " + clazz.getName());
        }
        return set.iterator().next();
    }

    ServiceRegistry getServiceRegistry() {
        return this.container().services();
    }

    Collection<Bean<?>> getAllBeans() {
        return this.container().beanDeploymentArchives().values().stream().map(BeanManagerImpl::getBeans).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    private <T> Bean<T> resolveUnique(Class<T> clazz) {
        return this.unique(clazz, this.resolve(clazz));
    }

    public void inject(Object o, ReleaseCallbackHandler handler) {
        this.withProducer(o, (b, p) -> p.inject(o, this.contextFor((Contextual)b, handler)));
    }

    void postConstruct(Object o) {
        this.withProducer(o, (b, p) -> p.postConstruct(o));
    }

    void preDestroy(Object o) {
        this.withProducer(o, (b, p) -> p.preDestroy(o));
    }

    private void withProducer(Object o, BiConsumer<Bean, InjectionTarget> consumer) {
        Bean<?> bean = this.resolveUnique(o.getClass());
        if (!(bean instanceof AbstractClassBean)) {
            throw new TestEEfiException("Injection of " + bean + " is not supported");
        }
        consumer.accept(bean, ((AbstractClassBean)bean).getProducer());
    }

    <T> CreationalContextImpl<T> contextFor(Contextual<T> ctx, ReleaseCallbackHandler handler) {
        CreationalContextImpl ret = this.rootContext.getCreationalContext(ctx);
        handler.add(() -> ((CreationalContextImpl)ret).release());
        return ret;
    }
}

