/*
 * Decompiled with CFR 0.152.
 */
package fi.testee.runtime;

import fi.testee.exceptions.TestEEfiException;
import fi.testee.jdbc.TestData;
import fi.testee.jdbc.TestDataSources;
import fi.testee.jpa.TestPersistenceUnits;
import fi.testee.services.JpaInjectionServicesImpl;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import javax.sql.DataSource;
import org.jboss.weld.bootstrap.api.ServiceRegistry;
import org.jboss.weld.injection.spi.ResourceInjectionServices;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class TestDataSetup {
    private static final Logger LOG = LoggerFactory.getLogger(TestDataSetup.class);

    private TestDataSetup() {
    }

    static void setupTestData(Class<?> setupClass, ServiceRegistry serviceRegistry) {
        JpaInjectionServicesImpl jpaInjectionServices = (JpaInjectionServicesImpl)serviceRegistry.get(JpaInjectionServicesImpl.class);
        ResourceInjectionServices resourceInjectionServices = (ResourceInjectionServices)serviceRegistry.get(ResourceInjectionServices.class);
        HashSet<Object> testDataSetupAccessors = new HashSet<Object>(Arrays.asList(TestDataSetup.testDataSources(resourceInjectionServices), TestDataSetup.testPersistenceUnits(jpaInjectionServices)));
        TestDataSetup.setupTestData(setupClass, testDataSetupAccessors);
    }

    private static TestPersistenceUnits testPersistenceUnits(JpaInjectionServicesImpl jpaInjectionServices) {
        return unitName -> (EntityManager)jpaInjectionServices.registerPersistenceContextInjectionPoint(unitName).createResource().getInstance();
    }

    private static TestDataSources testDataSources(ResourceInjectionServices resourceInjectionServices) {
        return mappedName -> (DataSource)resourceInjectionServices.registerResourceInjectionPoint(null, mappedName).createResource().getInstance();
    }

    public static void setupTestData(Class<?> setupClass, Collection<Object> testDataSetupAccessors) {
        ArrayList<Method> methodsToInvoke = new ArrayList<Method>();
        for (Class<?> currentClass = setupClass; currentClass != null && currentClass != Object.class; currentClass = currentClass.getSuperclass()) {
            Set candidates = Arrays.stream(currentClass.getDeclaredMethods()).filter(it -> it.getAnnotation(TestData.class) != null).collect(Collectors.toSet());
            if (candidates.isEmpty()) continue;
            if (candidates.size() > 1) {
                throw new IllegalStateException("Only one @TestData method allowed per class");
            }
            Method candidate = (Method)candidates.iterator().next();
            if (!Modifier.isStatic(candidate.getModifiers())) {
                throw new IllegalStateException("Methods annotated with @TestData must be static");
            }
            methodsToInvoke.add(0, candidate);
        }
        methodsToInvoke.forEach(it -> {
            LOG.debug("Invoking @TestData method {}", (Object)it.toString());
            try {
                it.setAccessible(true);
                Object[] arguments = TestDataSetup.resolveArguments(it.getParameterTypes(), testDataSetupAccessors);
                it.invoke(null, arguments);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new TestEEfiException("Failed to invoke @TestData method", (Throwable)e);
            }
        });
    }

    private static Object[] resolveArguments(Class<?>[] types, Collection<Object> candidates) {
        Object[] values = new Object[types.length];
        for (int i = 0; i < types.length; ++i) {
            values[i] = TestDataSetup.find(types[i], candidates);
        }
        return values;
    }

    private static Object find(Class<?> type, Collection<Object> candidates) {
        HashSet<Object> matches = new HashSet<Object>();
        for (Object candidate : candidates) {
            if (!type.isAssignableFrom(candidate.getClass())) continue;
            matches.add(candidate);
        }
        if (matches.isEmpty()) {
            throw new TestEEfiException("Unkonwn type for @TestData method parameter: " + type.getName());
        }
        if (matches.size() > 1) {
            throw new TestEEfiException("Ambiguous @TestData method parameter type: " + type.getName());
        }
        return matches.iterator().next();
    }
}

