/*
 * Decompiled with CFR 0.152.
 */
package fi.testee.runtime;

import fi.testee.deployment.BeanArchiveDiscovery;
import fi.testee.deployment.DeploymentImpl;
import fi.testee.ejb.EjbContainer;
import fi.testee.runtime.DeferredDependencyInjection;
import fi.testee.runtime.DependencyInjectionRealm;
import fi.testee.runtime.ManualResourceProviderBuilder;
import fi.testee.runtime.TestSetup;
import fi.testee.runtime.TransactionalContext;
import fi.testee.services.ResourceInjectionServicesImpl;
import fi.testee.spi.BeanModifier;
import fi.testee.spi.BeanModifierFactory;
import fi.testee.spi.BeansXmlModifier;
import fi.testee.spi.CdiExtensionFactory;
import fi.testee.spi.DependencyInjection;
import fi.testee.spi.ReleaseCallbackHandler;
import fi.testee.spi.Releaser;
import fi.testee.spi.ResourceProvider;
import fi.testee.spi.SessionBeanFactory;
import fi.testee.spi.scope.TestInstanceScope;
import fi.testee.spi.scope.TestSetupScope;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.Extension;
import org.jboss.weld.bootstrap.api.Environments;
import org.jboss.weld.bootstrap.api.Service;
import org.jboss.weld.bootstrap.api.ServiceRegistry;
import org.jboss.weld.bootstrap.api.helpers.SimpleServiceRegistry;
import org.jboss.weld.bootstrap.spi.BeansXml;
import org.jboss.weld.bootstrap.spi.Metadata;
import org.jboss.weld.injection.spi.ResourceInjectionServices;

public class TestInstanceRealm
extends DependencyInjectionRealm
implements TestSetup.TestInstance {
    private final Releaser releaser = new Releaser();
    private TransactionalContext context;
    private String instanceId;
    private Object testInstance;

    public TestInstanceRealm init(BeanArchiveDiscovery beanArchiveDiscovery, String instanceId, Object testInstance, Method method, Collection<ResourceProvider> setupResourceProviders) {
        super.init(TestInstanceRealm.serviceRegistry(this.resourceProviders(testInstance, method, setupResourceProviders)), beanArchiveDiscovery, Environments.SE, Collections.emptySet(), DeploymentImpl.UNMODIFIED);
        this.instanceId = instanceId;
        this.testInstance = testInstance;
        Set<ResourceProvider> resourceProviders = this.getInstancesOf(ResourceProvider.class, (ReleaseCallbackHandler)this.releaser);
        Set<BeanModifier> beanModifiers = this.beanModifiers(testInstance);
        SessionBeanModifierImpl beanModifier = new SessionBeanModifierImpl(beanModifiers);
        BeansXmlModifier beansXmlModifier = this.beansXmlModifiers();
        Collection<Metadata<Extension>> extensions = this.instanceExtensions(method);
        this.context = this.getInstanceOf(TransactionalContext.class, (ReleaseCallbackHandler)this.releaser);
        Annotation[] scopes = new Annotation[]{TestSetupScope.INSTANCE, TestInstanceScope.INSTANCE};
        this.context.initialize(beanModifier, extensions, beansXmlModifier, resourceProviders, scopes);
        this.context.run((clazz, testInstanceRealm) -> {
            testInstanceRealm.getAllBeans().forEach(this.modifyCdiBeans(beanModifiers));
            testInstanceRealm.inject(testInstance, (ReleaseCallbackHandler)this.releaser);
            testInstanceRealm.postConstruct(testInstance);
            return null;
        });
        return this;
    }

    private Collection<ResourceProvider> resourceProviders(Object testInstance, Method method, Collection<ResourceProvider> setupResourceProviders) {
        HashSet<ResourceProvider> ret = new HashSet<ResourceProvider>(setupResourceProviders);
        ret.add(new ManualResourceProviderBuilder().put("testeefi/instance/instance", testInstance).put("testeefi/instance/method", method).put("testeefi/instance/dependencyInjection", this.dependencyInjection()).build());
        return ret;
    }

    private DependencyInjection dependencyInjection() {
        return new DeferredDependencyInjection(() -> this.context.getDependencyInjection());
    }

    private Consumer<Bean<?>> modifyCdiBeans(Collection<BeanModifier> beanModifiers) {
        return bean -> beanModifiers.forEach(it -> it.modifyCdiBean(bean));
    }

    private Collection<Metadata<Extension>> instanceExtensions(Method method) {
        return this.getInstancesOf(CdiExtensionFactory.class, (ReleaseCallbackHandler)this.releaser).stream().map(factory -> factory.create(method)).filter(Objects::nonNull).map(this::testExtension).collect(Collectors.toSet());
    }

    private Metadata<Extension> testExtension(final Extension instance) {
        return new Metadata<Extension>(){

            public Extension getValue() {
                return instance;
            }

            public String getLocation() {
                return "TestEE.fi-extension:" + instance.getClass().getName();
            }
        };
    }

    private static ServiceRegistry serviceRegistry(Collection<ResourceProvider> resourceProviders) {
        SimpleServiceRegistry services = new SimpleServiceRegistry();
        services.add(ResourceInjectionServices.class, (Service)new ResourceInjectionServicesImpl(resourceProviders));
        return services;
    }

    private Set<BeanModifier> beanModifiers(Object testInstance) {
        return this.getInstancesOf(BeanModifierFactory.class, (ReleaseCallbackHandler)this.releaser).stream().map(it -> it.createBeanModifier(testInstance)).collect(Collectors.toSet());
    }

    @Override
    public <T> T create(Class<T> clazz, ReleaseCallbackHandler releaser) {
        return (T)this.context.run((setupClass, realm) -> realm.getInstanceOf(clazz, releaser));
    }

    @Override
    public void shutdown() {
        this.context.flushEntityManagers();
        this.context.run((clazz, testInstanceRealm) -> {
            testInstanceRealm.preDestroy(this.testInstance);
            return null;
        });
        this.releaser.release();
        super.shutdown();
    }

    @Override
    public String getId() {
        return this.instanceId;
    }

    private BeansXmlModifier beansXmlModifiers() {
        Set<BeansXmlModifier> modifiers = this.getInstancesOf(BeansXmlModifier.class, (ReleaseCallbackHandler)this.releaser);
        return beansXml -> {
            BeansXml ret = beansXml;
            for (BeansXmlModifier modifier : modifiers) {
                ret = (BeansXml)modifier.apply((Object)ret);
            }
            return ret;
        };
    }

    private static class SessionBeanModifierImpl
    implements EjbContainer.SessionBeanModifier {
        private final Set<BeanModifier> beanModifiers;

        private SessionBeanModifierImpl(Set<BeanModifier> beanModifiers) {
            this.beanModifiers = beanModifiers;
        }

        @Override
        public <T> SessionBeanFactory<T> modify(SessionBeanFactory<T> factory) {
            for (BeanModifier beanModifier : this.beanModifiers) {
                factory = beanModifier.modifySessionBean(factory);
            }
            return factory;
        }
    }
}

